/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CachingOptions;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.PCollection;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.impl.dist.DistributedPipeline;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.MRPipelineExecution;
import org.apache.crunch.impl.mr.collect.MRCollectionFactory;
import org.apache.crunch.impl.mr.exec.MRExecutor;
import org.apache.crunch.impl.mr.plan.MSCRPlanner;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.materialize.MaterializableIterable;
import org.apache.hadoop.conf.Configuration;

public class MRPipeline
extends DistributedPipeline {
    private static final Log LOG = LogFactory.getLog(MRPipeline.class);
    private final Class<?> jarClass;

    public MRPipeline(Class<?> jarClass) {
        this(jarClass, new Configuration());
    }

    public MRPipeline(Class<?> jarClass, String name) {
        this(jarClass, name, new Configuration());
    }

    public MRPipeline(Class<?> jarClass, Configuration conf) {
        this(jarClass, jarClass.getName(), conf);
    }

    public MRPipeline(Class<?> jarClass, String name, Configuration conf) {
        super(name, conf, new MRCollectionFactory());
        this.jarClass = jarClass;
    }

    public MRExecutor plan() {
        HashMap toMaterialize = Maps.newHashMap();
        for (PCollectionImpl c : this.outputTargets.keySet()) {
            if (!this.outputTargetsToMaterialize.containsKey(c)) continue;
            toMaterialize.put(c, this.outputTargetsToMaterialize.get(c));
            this.outputTargetsToMaterialize.remove(c);
        }
        MSCRPlanner planner = new MSCRPlanner(this, this.outputTargets, toMaterialize);
        try {
            return planner.plan(this.jarClass, this.getConfiguration());
        }
        catch (IOException e) {
            throw new CrunchRuntimeException(e);
        }
    }

    @Override
    public PipelineResult run() {
        try {
            MRPipelineExecution pipelineExecution = this.runAsync();
            pipelineExecution.waitUntilDone();
            return pipelineExecution.getResult();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception running pipeline", (Throwable)e);
            return PipelineResult.EMPTY;
        }
    }

    @Override
    public MRPipelineExecution runAsync() {
        MRPipelineExecution res = this.plan().execute();
        this.outputTargets.clear();
        return res;
    }

    @Override
    public <T> Iterable<T> materialize(PCollection<T> pcollection) {
        ((PCollectionImpl)pcollection).setBreakpoint();
        ReadableSource<T> readableSrc = this.getMaterializeSourceTarget(pcollection);
        MaterializableIterable<T> c = new MaterializableIterable<T>(this, readableSrc);
        if (!this.outputTargetsToMaterialize.containsKey(pcollection)) {
            this.outputTargetsToMaterialize.put((PCollectionImpl)pcollection, c);
        }
        return c;
    }

    @Override
    public <T> void cache(PCollection<T> pcollection, CachingOptions options) {
        this.materialize(pcollection);
    }
}

