/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.Pair;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.collect.InputCollection;
import org.apache.crunch.impl.mr.collect.PGroupedTableImpl;
import org.apache.crunch.impl.mr.plan.JobPrototype;
import org.apache.crunch.impl.mr.plan.NodePath;

public class DotfileWriter {
    private Set<JobPrototype> jobPrototypes = Sets.newHashSet();
    private HashMultimap<Pair<JobPrototype, MRTaskType>, String> jobNodeDeclarations = HashMultimap.create();
    private Set<String> globalNodeDeclarations = Sets.newHashSet();
    private Set<String> nodePathChains = Sets.newHashSet();

    String formatPCollectionNodeDeclaration(PCollectionImpl<?> pcollectionImpl, JobPrototype jobPrototype) {
        String shape = "box";
        if (pcollectionImpl instanceof InputCollection) {
            shape = "folder";
        }
        return String.format("%s [label=\"%s\" shape=%s];", this.formatPCollection(pcollectionImpl, jobPrototype), pcollectionImpl.getName(), shape);
    }

    String formatTargetNodeDeclaration(Target target) {
        return String.format("\"%s\" [label=\"%s\" shape=folder];", target.toString(), target.toString());
    }

    String formatPCollection(PCollectionImpl<?> pcollectionImpl, JobPrototype jobPrototype) {
        if (pcollectionImpl instanceof InputCollection) {
            InputCollection inputCollection = (InputCollection)pcollectionImpl;
            return String.format("\"%s\"", inputCollection.getSource());
        }
        return String.format("\"%s@%d@%d\"", pcollectionImpl.getName(), pcollectionImpl.hashCode(), jobPrototype.hashCode());
    }

    String formatNodeCollection(List<String> nodeCollection) {
        return this.formatNodeCollection(nodeCollection, (Map<String, String>)ImmutableMap.of());
    }

    String formatNodeCollection(List<String> nodeCollection, Map<String, String> edgeAttributes) {
        String edgeAttributeString = "";
        if (!edgeAttributes.isEmpty()) {
            edgeAttributeString = String.format(" [%s]", Joiner.on((char)' ').withKeyValueSeparator("=").join(edgeAttributes));
        }
        return String.format("%s%s;", Joiner.on((String)" -> ").join(nodeCollection), edgeAttributeString);
    }

    List<String> formatNodePath(NodePath nodePath, JobPrototype jobPrototype) {
        ArrayList formattedNodePaths = Lists.newArrayList();
        ImmutableList pcollections = ImmutableList.copyOf((Iterable)nodePath);
        for (int collectionIndex = 1; collectionIndex < pcollections.size(); ++collectionIndex) {
            String fromNode = this.formatPCollection((PCollectionImpl)pcollections.get(collectionIndex - 1), jobPrototype);
            String toNode = this.formatPCollection((PCollectionImpl)pcollections.get(collectionIndex), jobPrototype);
            formattedNodePaths.add(this.formatNodeCollection((List<String>)ImmutableList.of((Object)fromNode, (Object)toNode)));
        }
        for (PCollectionImpl pcollection : pcollections) {
            Set<SourceTarget<?>> targetDeps = pcollection.getParallelDoOptions().getSourceTargets();
            if (targetDeps.isEmpty()) continue;
            String toNode = this.formatPCollection(pcollection, jobPrototype);
            for (SourceTarget<?> target : targetDeps) {
                this.globalNodeDeclarations.add(this.formatTargetNodeDeclaration(target));
                String fromNode = String.format("\"%s\"", target.toString());
                formattedNodePaths.add(this.formatNodeCollection((List<String>)ImmutableList.of((Object)fromNode, (Object)toNode), (Map<String, String>)ImmutableMap.of((Object)"style", (Object)"dashed")));
            }
        }
        return formattedNodePaths;
    }

    void addNodePathDeclarations(JobPrototype jobPrototype, NodePath nodePath) {
        boolean groupingEncountered = false;
        for (PCollectionImpl<?> pcollectionImpl : nodePath) {
            if (pcollectionImpl instanceof InputCollection) {
                this.globalNodeDeclarations.add(this.formatPCollectionNodeDeclaration(pcollectionImpl, jobPrototype));
                continue;
            }
            if (!groupingEncountered) {
                groupingEncountered = pcollectionImpl instanceof PGroupedTableImpl;
            }
            MRTaskType taskType = groupingEncountered ? MRTaskType.REDUCE : MRTaskType.MAP;
            this.jobNodeDeclarations.put(Pair.of(jobPrototype, taskType), (Object)this.formatPCollectionNodeDeclaration(pcollectionImpl, jobPrototype));
        }
    }

    void addNodePathChain(NodePath nodePath, JobPrototype jobPrototype) {
        for (String nodePathChain : this.formatNodePath(nodePath, jobPrototype)) {
            this.nodePathChains.add(nodePathChain);
        }
    }

    String getTaskGraphAttributes(MRTaskType taskType) {
        if (taskType == MRTaskType.MAP) {
            return "label = Map; color = blue;";
        }
        return "label = Reduce; color = red;";
    }

    private void processNodePaths(JobPrototype jobPrototype, HashMultimap<Target, NodePath> nodePaths) {
        if (nodePaths != null) {
            for (Target target : nodePaths.keySet()) {
                this.globalNodeDeclarations.add(this.formatTargetNodeDeclaration(target));
                for (NodePath nodePath : nodePaths.get((Object)target)) {
                    this.addNodePathDeclarations(jobPrototype, nodePath);
                    this.addNodePathChain(nodePath, jobPrototype);
                    this.nodePathChains.add(this.formatNodeCollection(Lists.newArrayList((Object[])new String[]{this.formatPCollection(nodePath.descendingIterator().next(), jobPrototype), String.format("\"%s\"", target.toString())})));
                }
            }
        }
    }

    public void addJobPrototype(JobPrototype jobPrototype) {
        this.jobPrototypes.add(jobPrototype);
        if (!jobPrototype.isMapOnly()) {
            for (NodePath nodePath : jobPrototype.getMapNodePaths()) {
                this.addNodePathDeclarations(jobPrototype, nodePath);
                this.addNodePathChain(nodePath, jobPrototype);
            }
            this.processNodePaths(jobPrototype, jobPrototype.getMapSideNodePaths());
        }
        this.processNodePaths(jobPrototype, jobPrototype.getTargetsToNodePaths());
    }

    public String buildDotfile() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph G {\n");
        for (String globalDeclaration : this.globalNodeDeclarations) {
            stringBuilder.append(String.format("  %s\n", globalDeclaration));
        }
        for (JobPrototype jobPrototype : this.jobPrototypes) {
            StringBuilder jobProtoStringBuilder = new StringBuilder();
            jobProtoStringBuilder.append(String.format("  subgraph \"cluster-job%d\" {\n", jobPrototype.getJobID()));
            jobProtoStringBuilder.append(String.format("    label=\"Crunch Job %d\";\n", jobPrototype.getJobID()));
            for (MRTaskType taskType : MRTaskType.values()) {
                Pair<JobPrototype, MRTaskType> jobTaskKey = Pair.of(jobPrototype, taskType);
                if (!this.jobNodeDeclarations.containsKey(jobTaskKey)) continue;
                jobProtoStringBuilder.append(String.format("    subgraph \"cluster-job%d-%s\" {\n", jobPrototype.getJobID(), taskType.name().toLowerCase()));
                jobProtoStringBuilder.append(String.format("      %s\n", this.getTaskGraphAttributes(taskType)));
                for (String declarationEntry : this.jobNodeDeclarations.get(jobTaskKey)) {
                    jobProtoStringBuilder.append(String.format("      %s\n", declarationEntry));
                }
                jobProtoStringBuilder.append("    }\n");
            }
            jobProtoStringBuilder.append("  }\n");
            stringBuilder.append(jobProtoStringBuilder.toString());
        }
        for (String nodePathChain : this.nodePathChains) {
            stringBuilder.append(String.format("  %s\n", nodePathChain));
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    static enum MRTaskType {
        MAP,
        REDUCE;

    }
}

