/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.Pair;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.plan.Edge;
import org.apache.crunch.impl.mr.plan.Vertex;

class Graph
implements Iterable<Vertex> {
    private final Map<PCollectionImpl, Vertex> vertices = Maps.newHashMap();
    private final Map<Pair<Vertex, Vertex>, Edge> edges = Maps.newHashMap();
    private final Map<Vertex, List<Vertex>> dependencies = Maps.newHashMap();

    public Vertex getVertexAt(PCollectionImpl impl) {
        return this.vertices.get(impl);
    }

    public Vertex addVertex(PCollectionImpl impl, boolean output) {
        if (this.vertices.containsKey(impl)) {
            Vertex v = this.vertices.get(impl);
            if (output) {
                v.setOutput();
            }
            return v;
        }
        Vertex v = new Vertex(impl);
        this.vertices.put(impl, v);
        if (output) {
            v.setOutput();
        }
        return v;
    }

    public Edge getEdge(Vertex head, Vertex tail) {
        Pair<Vertex, Vertex> p = Pair.of(head, tail);
        if (this.edges.containsKey(p)) {
            return this.edges.get(p);
        }
        Edge e = new Edge(head, tail);
        this.edges.put(p, e);
        tail.addIncoming(e);
        head.addOutgoing(e);
        return e;
    }

    @Override
    public Iterator<Vertex> iterator() {
        return Sets.newHashSet(this.vertices.values()).iterator();
    }

    public Set<Edge> getAllEdges() {
        return Sets.newHashSet(this.edges.values());
    }

    public void markDependency(Vertex child, Vertex parent) {
        ArrayList parents = this.dependencies.get(child);
        if (parents == null) {
            parents = Lists.newArrayList();
            this.dependencies.put(child, parents);
        }
        parents.add(parent);
    }

    public List<Vertex> getParents(Vertex child) {
        if (this.dependencies.containsKey(child)) {
            return this.dependencies.get(child);
        }
        return ImmutableList.of();
    }

    public List<List<Vertex>> connectedComponents() {
        ArrayList components = Lists.newArrayList();
        HashSet unassigned = Sets.newHashSet(this.vertices.values());
        while (!unassigned.isEmpty()) {
            Vertex base = (Vertex)unassigned.iterator().next();
            ArrayList component = Lists.newArrayList();
            component.add(base);
            unassigned.remove(base);
            HashSet working = Sets.newHashSet(base.getAllNeighbors());
            while (!working.isEmpty()) {
                Vertex n = (Vertex)working.iterator().next();
                working.remove(n);
                if (!unassigned.contains(n)) continue;
                component.add(n);
                unassigned.remove(n);
                for (Vertex n2 : n.getAllNeighbors()) {
                    if (!unassigned.contains(n2)) continue;
                    working.add(n2);
                }
            }
            components.add(component);
        }
        return components;
    }
}

