/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.Pipeline;
import org.apache.crunch.Target;
import org.apache.crunch.hadoop.mapreduce.lib.jobcontrol.CrunchControlledJob;
import org.apache.crunch.impl.dist.collect.MRCollection;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.collect.DoTable;
import org.apache.crunch.impl.mr.collect.PGroupedTableImpl;
import org.apache.crunch.impl.mr.exec.CrunchJobHooks;
import org.apache.crunch.impl.mr.plan.DoNode;
import org.apache.crunch.impl.mr.plan.JobNameBuilder;
import org.apache.crunch.impl.mr.plan.MSCROutputHandler;
import org.apache.crunch.impl.mr.plan.NodePath;
import org.apache.crunch.impl.mr.run.CrunchCombiner;
import org.apache.crunch.impl.mr.run.CrunchInputFormat;
import org.apache.crunch.impl.mr.run.CrunchMapper;
import org.apache.crunch.impl.mr.run.CrunchReducer;
import org.apache.crunch.impl.mr.run.NodeContext;
import org.apache.crunch.types.PType;
import org.apache.crunch.util.DistCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

class JobPrototype {
    private final int jobID;
    private final Set<NodePath> mapNodePaths;
    private final PGroupedTableImpl<?, ?> group;
    private final Set<JobPrototype> dependencies = Sets.newHashSet();
    private final Map<PCollectionImpl<?>, DoNode> nodes = Maps.newHashMap();
    private final Path workingPath;
    private HashMultimap<Target, NodePath> mapSideNodePaths;
    private HashMultimap<Target, NodePath> targetsToNodePaths;
    private DoTable<?, ?> combineFnTable;
    private CrunchControlledJob job;

    public static JobPrototype createMapReduceJob(int jobID, PGroupedTableImpl<?, ?> group, Set<NodePath> inputs, Path workingPath) {
        return new JobPrototype(jobID, inputs, group, workingPath);
    }

    public static JobPrototype createMapOnlyJob(int jobID, HashMultimap<Target, NodePath> mapNodePaths, Path workingPath) {
        return new JobPrototype(jobID, mapNodePaths, workingPath);
    }

    private JobPrototype(int jobID, Set<NodePath> inputs, PGroupedTableImpl<?, ?> group, Path workingPath) {
        this.jobID = jobID;
        this.mapNodePaths = ImmutableSet.copyOf(inputs);
        this.group = group;
        this.workingPath = workingPath;
        this.targetsToNodePaths = null;
    }

    private JobPrototype(int jobID, HashMultimap<Target, NodePath> outputPaths, Path workingPath) {
        this.jobID = jobID;
        this.group = null;
        this.mapNodePaths = null;
        this.workingPath = workingPath;
        this.targetsToNodePaths = outputPaths;
    }

    public int getJobID() {
        return this.jobID;
    }

    public boolean isMapOnly() {
        return this.group == null;
    }

    Set<NodePath> getMapNodePaths() {
        return this.mapNodePaths;
    }

    HashMultimap<Target, NodePath> getMapSideNodePaths() {
        return this.mapSideNodePaths;
    }

    HashMultimap<Target, NodePath> getTargetsToNodePaths() {
        return this.targetsToNodePaths;
    }

    public void addMapSideOutputs(HashMultimap<Target, NodePath> mapSideNodePaths) {
        if (this.group == null) {
            throw new IllegalStateException("Cannot side-outputs to a map-only job");
        }
        this.mapSideNodePaths = mapSideNodePaths;
    }

    public void addReducePaths(HashMultimap<Target, NodePath> outputPaths) {
        if (this.group == null) {
            throw new IllegalStateException("Cannot add a reduce phase to a map-only job");
        }
        this.targetsToNodePaths = outputPaths;
    }

    public void addDependency(JobPrototype dependency) {
        this.dependencies.add(dependency);
    }

    public CrunchControlledJob getCrunchJob(Class<?> jarClass, Configuration conf, Pipeline pipeline, int numOfJobs) throws IOException {
        if (this.job == null) {
            this.job = this.build(jarClass, conf, pipeline, numOfJobs);
            for (JobPrototype proto : this.dependencies) {
                this.job.addDependingJob(proto.getCrunchJob(jarClass, conf, pipeline, numOfJobs));
            }
        }
        return this.job;
    }

    private CrunchControlledJob build(Class<?> jarClass, Configuration conf, Pipeline pipeline, int numOfJobs) throws IOException {
        ArrayList inputNodes;
        Job job = new Job(conf);
        conf = job.getConfiguration();
        conf.set("crunch.work.dir", this.workingPath.toString());
        job.setJarByClass(jarClass);
        HashSet outputNodes = Sets.newHashSet();
        Path outputPath = new Path(this.workingPath, "output");
        MSCROutputHandler outputHandler = new MSCROutputHandler(job, outputPath, this.group == null);
        for (Target target : this.targetsToNodePaths.keySet()) {
            DoNode node = null;
            for (NodePath nodePath : this.targetsToNodePaths.get((Object)target)) {
                if (node == null) {
                    PType ptype = nodePath.tail().getPType();
                    node = DoNode.createOutputNode(target.toString(), target.getConverter(ptype), ptype);
                    outputHandler.configureNode(node, target);
                }
                outputNodes.add(this.walkPath(nodePath.descendingIterator(), node));
            }
        }
        HashSet mapSideNodes = Sets.newHashSet();
        if (this.mapSideNodePaths != null) {
            for (Target target : this.mapSideNodePaths.keySet()) {
                DoNode node = null;
                for (NodePath nodePath : this.mapSideNodePaths.get((Object)target)) {
                    if (node == null) {
                        PType ptype = nodePath.tail().getPType();
                        node = DoNode.createOutputNode(target.toString(), target.getConverter(ptype), ptype);
                        outputHandler.configureNode(node, target);
                    }
                    mapSideNodes.add(this.walkPath(nodePath.descendingIterator(), node));
                }
            }
        }
        job.setMapperClass(CrunchMapper.class);
        DoNode reduceNode = null;
        if (this.group != null) {
            job.setReducerClass(CrunchReducer.class);
            ArrayList reduceNodes = Lists.newArrayList((Iterable)outputNodes);
            this.serialize(reduceNodes, conf, this.workingPath, NodeContext.REDUCE);
            reduceNode = (DoNode)reduceNodes.get(0);
            if (this.combineFnTable != null) {
                job.setCombinerClass(CrunchCombiner.class);
                DoNode combinerInputNode = this.group.createDoNode();
                DoNode combineNode = this.combineFnTable.createCombineNode();
                combineNode.addChild(this.group.getGroupingNode());
                combinerInputNode.addChild(combineNode);
                this.serialize((List<DoNode>)ImmutableList.of((Object)combinerInputNode), conf, this.workingPath, NodeContext.COMBINE);
            }
            this.group.configureShuffle(job);
            DoNode mapOutputNode = this.group.getGroupingNode();
            HashSet mapNodes = Sets.newHashSet((Iterable)mapSideNodes);
            for (NodePath nodePath : this.mapNodePaths) {
                Iterator<PCollectionImpl<?>> iter = nodePath.descendingIterator();
                iter.next();
                mapNodes.add(this.walkPath(iter, mapOutputNode));
            }
            inputNodes = Lists.newArrayList((Iterable)mapNodes);
        } else {
            job.setNumReduceTasks(0);
            inputNodes = Lists.newArrayList((Iterable)outputNodes);
        }
        this.serialize(inputNodes, conf, this.workingPath, NodeContext.MAP);
        if (inputNodes.size() == 1) {
            DoNode inputNode = (DoNode)inputNodes.get(0);
            inputNode.getSource().configureSource(job, -1);
        } else {
            for (int i = 0; i < inputNodes.size(); ++i) {
                ((DoNode)inputNodes.get(i)).getSource().configureSource(job, i);
            }
            job.setInputFormatClass(CrunchInputFormat.class);
        }
        JobNameBuilder jobNameBuilder = this.createJobNameBuilder(conf, pipeline.getName(), inputNodes, reduceNode, numOfJobs);
        return new CrunchControlledJob(this.jobID, job, jobNameBuilder, new CrunchJobHooks.PrepareHook(job), new CrunchJobHooks.CompletionHook(job, outputPath, outputHandler.getMultiPaths(), this.group == null));
    }

    private void serialize(List<DoNode> nodes, Configuration conf, Path workingPath, NodeContext context) throws IOException {
        ArrayList rtNodes = Lists.newArrayList();
        for (DoNode node : nodes) {
            rtNodes.add(node.toRTNode(true, conf, context));
        }
        Path path = new Path(workingPath, context.toString());
        DistCache.write(conf, path, rtNodes);
    }

    private JobNameBuilder createJobNameBuilder(Configuration conf, String pipelineName, List<DoNode> mapNodes, DoNode reduceNode, int numOfJobs) {
        JobNameBuilder builder = new JobNameBuilder(conf, pipelineName, this.jobID, numOfJobs);
        builder.visit(mapNodes);
        if (reduceNode != null) {
            builder.visit(reduceNode);
        }
        return builder;
    }

    private DoNode walkPath(Iterator<PCollectionImpl<?>> iter, DoNode working) {
        while (iter.hasNext()) {
            PCollectionImpl<?> collect = iter.next();
            if (this.combineFnTable != null && !(collect instanceof PGroupedTableImpl)) {
                this.combineFnTable = null;
            } else if (collect instanceof DoTable && ((DoTable)collect).hasCombineFn()) {
                this.combineFnTable = (DoTable)collect;
            }
            if (!this.nodes.containsKey(collect)) {
                this.nodes.put(collect, ((MRCollection)((Object)collect)).createDoNode());
            }
            DoNode parent = this.nodes.get(collect);
            parent.addChild(working);
            working = parent;
        }
        return working;
    }
}

