/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.Source;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.MRPipeline;
import org.apache.crunch.impl.mr.collect.InputCollection;
import org.apache.crunch.impl.mr.collect.PGroupedTableImpl;
import org.apache.crunch.impl.mr.exec.MRExecutor;
import org.apache.crunch.impl.mr.plan.DotfileWriter;
import org.apache.crunch.impl.mr.plan.Edge;
import org.apache.crunch.impl.mr.plan.Graph;
import org.apache.crunch.impl.mr.plan.GraphBuilder;
import org.apache.crunch.impl.mr.plan.JobPrototype;
import org.apache.crunch.impl.mr.plan.NodePath;
import org.apache.crunch.impl.mr.plan.Vertex;
import org.apache.crunch.materialize.MaterializableIterable;
import org.apache.hadoop.conf.Configuration;

public class MSCRPlanner {
    private static final Log LOG = LogFactory.getLog(MSCRPlanner.class);
    private final MRPipeline pipeline;
    private final Map<PCollectionImpl<?>, Set<Target>> outputs;
    private final Map<PCollectionImpl<?>, MaterializableIterable> toMaterialize;
    private int lastJobID = 0;
    static final Comparator<PCollectionImpl<?>> DEPTH_COMPARATOR = new Comparator<PCollectionImpl<?>>(){

        @Override
        public int compare(PCollectionImpl<?> left, PCollectionImpl<?> right) {
            int cmp = right.getDepth() - left.getDepth();
            if (cmp == 0) {
                cmp = new Integer(right.hashCode()).compareTo(left.hashCode());
            }
            return cmp;
        }
    };

    public MSCRPlanner(MRPipeline pipeline, Map<PCollectionImpl<?>, Set<Target>> outputs, Map<PCollectionImpl<?>, MaterializableIterable> toMaterialize) {
        this.pipeline = pipeline;
        this.outputs = new TreeMap(DEPTH_COMPARATOR);
        this.outputs.putAll(outputs);
        this.toMaterialize = toMaterialize;
    }

    public MRExecutor plan(Class<?> jarClass, Configuration conf) throws IOException {
        TreeMap targetDeps = Maps.newTreeMap(DEPTH_COMPARATOR);
        for (PCollectionImpl<?> pcollect : this.outputs.keySet()) {
            targetDeps.put(pcollect, pcollect.getTargetDependencies());
        }
        HashMultimap assignments = HashMultimap.create();
        while (!targetDeps.isEmpty()) {
            HashSet allTargets = Sets.newHashSet();
            for (PCollectionImpl pcollect : targetDeps.keySet()) {
                allTargets.addAll((Collection)this.outputs.get(pcollect));
            }
            GraphBuilder graphBuilder = new GraphBuilder();
            HashSet currentStage = Sets.newHashSet();
            for (PCollectionImpl output : targetDeps.keySet()) {
                Sets.SetView deps = Sets.intersection((Set)allTargets, (Set)((Set)targetDeps.get(output)));
                if (!deps.isEmpty()) continue;
                graphBuilder.visitOutput(output);
                currentStage.add(output);
            }
            Graph baseGraph = graphBuilder.getGraph();
            boolean hasInputs = false;
            for (Vertex v : baseGraph) {
                if (!v.isInput()) continue;
                hasInputs = true;
                break;
            }
            if (!hasInputs) {
                LOG.warn((Object)"No input sources for pipeline, nothing to do...");
                return new MRExecutor(conf, jarClass, this.outputs, this.toMaterialize);
            }
            Graph graph = this.prepareFinalGraph(baseGraph);
            List<List<Vertex>> components = graph.connectedComponents();
            HashMultimap newAssignments = HashMultimap.create();
            for (List<Vertex> component : components) {
                newAssignments.putAll(this.constructJobPrototypes(component, components.size()));
            }
            for (Map.Entry e : newAssignments.entries()) {
                JobPrototype current = (JobPrototype)e.getValue();
                List<Vertex> parents = graph.getParents((Vertex)e.getKey());
                for (Vertex parent : parents) {
                    for (JobPrototype parentJobProto : newAssignments.get((Object)parent)) {
                        current.addDependency(parentJobProto);
                    }
                }
            }
            ImmutableMultimap previousStages = ImmutableMultimap.copyOf((Multimap)assignments);
            for (Map.Entry e : newAssignments.entries()) {
                JobPrototype current;
                if (((Vertex)e.getKey()).isOutput()) {
                    PCollectionImpl pcollect = ((Vertex)e.getKey()).getPCollection();
                    current = (JobPrototype)e.getValue();
                    for (SourceTarget<?> pt : pcollect.getTargetDependencies()) {
                        for (JobPrototype parentJobProto : assignments.get(pt)) {
                            current.addDependency(parentJobProto);
                        }
                    }
                    for (Target t : this.outputs.get(pcollect)) {
                        assignments.put((Object)t, e.getValue());
                    }
                    continue;
                }
                Source source = ((Vertex)e.getKey()).getSource();
                if (source == null || !(source instanceof Target)) continue;
                current = (JobPrototype)e.getValue();
                ImmutableCollection parentJobPrototypes = previousStages.get((Object)((Target)((Object)source)));
                if (parentJobPrototypes == null) continue;
                for (JobPrototype parentJobProto : parentJobPrototypes) {
                    current.addDependency(parentJobProto);
                }
            }
            for (PCollectionImpl output : currentStage) {
                MaterializableIterable mi;
                if (this.toMaterialize.containsKey(output) && (mi = this.toMaterialize.get(output)).isSourceTarget()) {
                    output.materializeAt((SourceTarget)((Object)mi.getSource()));
                }
                targetDeps.remove(output);
            }
        }
        DotfileWriter dotfileWriter = new DotfileWriter();
        MRExecutor exec = new MRExecutor(conf, jarClass, this.outputs, this.toMaterialize);
        for (JobPrototype proto : Sets.newHashSet((Iterable)assignments.values())) {
            dotfileWriter.addJobPrototype(proto);
            exec.addJob(proto.getCrunchJob(jarClass, conf, this.pipeline, this.lastJobID));
        }
        String planDotFile = dotfileWriter.buildDotfile();
        exec.setPlanDotFile(planDotFile);
        conf.set("crunch.planner.dotfile", planDotFile);
        return exec;
    }

    private Graph prepareFinalGraph(Graph baseGraph) {
        Graph graph = new Graph();
        for (Vertex baseVertex : baseGraph) {
            graph.addVertex(baseVertex.getPCollection(), baseVertex.isOutput());
        }
        for (Edge e : baseGraph.getAllEdges()) {
            if (e.getHead().isGBK() && e.getTail().isGBK() || e.getHead().isOutput() && e.getTail().isGBK()) continue;
            Vertex head = graph.getVertexAt(e.getHead().getPCollection());
            Vertex tail = graph.getVertexAt(e.getTail().getPCollection());
            graph.getEdge(head, tail).addAllNodePaths(e.getNodePaths());
        }
        for (Vertex baseVertex : baseGraph) {
            if (!baseVertex.isGBK()) continue;
            Vertex vertex = graph.getVertexAt(baseVertex.getPCollection());
            for (Edge e : baseVertex.getIncomingEdges()) {
                if (e.getHead().isOutput()) {
                    Vertex splitTail = e.getHead();
                    PCollectionImpl split = splitTail.getPCollection();
                    InputCollection<?> inputNode = this.handleSplitTarget(split);
                    Vertex splitHead = graph.addVertex(inputNode, false);
                    for (NodePath path : e.getNodePaths()) {
                        NodePath headPath = path.splitAt(split, splitHead.getPCollection());
                        graph.getEdge(vertex, splitTail).addNodePath(headPath);
                        graph.getEdge(splitHead, vertex).addNodePath(path);
                    }
                    graph.markDependency(splitHead, splitTail);
                    continue;
                }
                if (e.getHead().isGBK()) continue;
                Vertex newHead = graph.getVertexAt(e.getHead().getPCollection());
                graph.getEdge(newHead, vertex).addAllNodePaths(e.getNodePaths());
            }
            for (Edge e : baseVertex.getOutgoingEdges()) {
                if (!e.getTail().isGBK()) {
                    Vertex newTail = graph.getVertexAt(e.getTail().getPCollection());
                    graph.getEdge(vertex, newTail).addAllNodePaths(e.getNodePaths());
                    continue;
                }
                Vertex newGraphTail = graph.getVertexAt(e.getTail().getPCollection());
                Map<NodePath, PCollectionImpl> splitPoints = e.getSplitPoints(this.outputs);
                for (Map.Entry<NodePath, PCollectionImpl> s : splitPoints.entrySet()) {
                    NodePath path = s.getKey();
                    PCollectionImpl split = s.getValue();
                    InputCollection<?> inputNode = this.handleSplitTarget(split);
                    Vertex splitTail = graph.addVertex(split, true);
                    Vertex splitHead = graph.addVertex(inputNode, false);
                    NodePath headPath = path.splitAt(split, splitHead.getPCollection());
                    graph.getEdge(vertex, splitTail).addNodePath(headPath);
                    graph.getEdge(splitHead, newGraphTail).addNodePath(path);
                    graph.markDependency(splitHead, splitTail);
                }
            }
        }
        return graph;
    }

    private Multimap<Vertex, JobPrototype> constructJobPrototypes(List<Vertex> component, int numOfJobs) {
        HashMultimap assignment;
        block23: {
            ArrayList gbks;
            block22: {
                assignment = HashMultimap.create();
                gbks = Lists.newArrayList();
                for (Vertex v : component) {
                    if (!v.isGBK()) continue;
                    gbks.add(v);
                }
                if (!gbks.isEmpty()) break block22;
                HashMultimap outputPaths = HashMultimap.create();
                for (Vertex v : component) {
                    if (!v.isInput()) continue;
                    for (Edge e : v.getOutgoingEdges()) {
                        for (NodePath nodePath : e.getNodePaths()) {
                            PCollectionImpl<?> target = nodePath.tail();
                            for (Target t : this.outputs.get(target)) {
                                outputPaths.put((Object)t, (Object)nodePath);
                            }
                        }
                    }
                }
                if (outputPaths.isEmpty()) {
                    throw new IllegalStateException("No outputs?");
                }
                JobPrototype prototype = JobPrototype.createMapOnlyJob(++this.lastJobID, (HashMultimap<Target, NodePath>)outputPaths, this.pipeline.createTempPath());
                for (Vertex v : component) {
                    assignment.put((Object)v, (Object)prototype);
                }
                break block23;
            }
            HashSet usedEdges = Sets.newHashSet();
            for (Vertex g : gbks) {
                HashSet inputs = Sets.newHashSet();
                HashMultimap mapSideOutputPaths = HashMultimap.create();
                for (Edge e : g.getIncomingEdges()) {
                    inputs.addAll(e.getNodePaths());
                    usedEdges.add(e);
                    if (!e.getHead().isInput()) continue;
                    for (Edge ep : e.getHead().getOutgoingEdges()) {
                        if (!ep.getTail().isOutput() || usedEdges.contains(ep)) continue;
                        for (Target t : this.outputs.get(ep.getTail().getPCollection())) {
                            mapSideOutputPaths.putAll((Object)t, ep.getNodePaths());
                        }
                        usedEdges.add(ep);
                    }
                }
                JobPrototype prototype = JobPrototype.createMapReduceJob(++this.lastJobID, (PGroupedTableImpl)g.getPCollection(), inputs, this.pipeline.createTempPath());
                prototype.addMapSideOutputs((HashMultimap<Target, NodePath>)mapSideOutputPaths);
                assignment.put((Object)g, (Object)prototype);
                for (Edge e : g.getIncomingEdges()) {
                    assignment.put((Object)e.getHead(), (Object)prototype);
                    if (!e.getHead().isInput()) continue;
                    for (Edge ep : e.getHead().getOutgoingEdges()) {
                        if (!ep.getTail().isOutput() || assignment.containsKey((Object)ep.getTail())) continue;
                        assignment.put((Object)ep.getTail(), (Object)prototype);
                    }
                }
                HashMultimap outputPaths = HashMultimap.create();
                for (Edge e : g.getOutgoingEdges()) {
                    Vertex output = e.getTail();
                    for (Target t : this.outputs.get(output.getPCollection())) {
                        outputPaths.putAll((Object)t, e.getNodePaths());
                    }
                    assignment.put((Object)output, (Object)prototype);
                    usedEdges.add(e);
                }
                prototype.addReducePaths((HashMultimap<Target, NodePath>)outputPaths);
            }
            HashMultimap outputPaths = HashMultimap.create();
            HashSet orphans = Sets.newHashSet();
            for (Vertex v : component) {
                boolean vertexHasUnassignedIncomingEdges = false;
                if (v.isOutput()) {
                    for (Edge e : v.getIncomingEdges()) {
                        if (usedEdges.contains(e)) continue;
                        vertexHasUnassignedIncomingEdges = true;
                    }
                }
                if (!v.isOutput() || !vertexHasUnassignedIncomingEdges && assignment.containsKey((Object)v)) continue;
                orphans.add(v);
                for (Edge e : v.getIncomingEdges()) {
                    if (vertexHasUnassignedIncomingEdges && usedEdges.contains(e)) continue;
                    orphans.add(e.getHead());
                    for (NodePath nodePath : e.getNodePaths()) {
                        PCollectionImpl<?> target = nodePath.tail();
                        for (Target t : this.outputs.get(target)) {
                            outputPaths.put((Object)t, (Object)nodePath);
                        }
                    }
                }
            }
            if (outputPaths.isEmpty()) break block23;
            JobPrototype prototype = JobPrototype.createMapOnlyJob(++this.lastJobID, (HashMultimap<Target, NodePath>)outputPaths, this.pipeline.createTempPath());
            for (Vertex orphan : orphans) {
                assignment.put((Object)orphan, (Object)prototype);
            }
        }
        return assignment;
    }

    private InputCollection<?> handleSplitTarget(PCollectionImpl<?> splitTarget) {
        if (!this.outputs.containsKey(splitTarget)) {
            this.outputs.put(splitTarget, Sets.newHashSet());
        }
        SourceTarget srcTarget = null;
        Target targetToReplace = null;
        for (Target t : this.outputs.get(splitTarget)) {
            if (t instanceof SourceTarget) {
                srcTarget = (SourceTarget)t;
                break;
            }
            srcTarget = t.asSourceTarget(splitTarget.getPType());
            if (srcTarget == null) continue;
            targetToReplace = t;
            break;
        }
        if (targetToReplace != null) {
            this.outputs.get(splitTarget).remove(targetToReplace);
        } else if (srcTarget == null) {
            srcTarget = this.pipeline.createIntermediateOutput(splitTarget.getPType());
        }
        this.outputs.get(splitTarget).add(srcTarget);
        splitTarget.materializeAt(srcTarget);
        return (InputCollection)this.pipeline.read(srcTarget);
    }
}

