/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;

public class CrunchCombineFileInputFormat<K, V>
extends CombineFileInputFormat<K, V> {
    public CrunchCombineFileInputFormat(JobContext jobContext) {
        if (CrunchCombineFileInputFormat.getMaxSplitSize((JobContext)jobContext) == Long.MAX_VALUE) {
            Configuration conf = jobContext.getConfiguration();
            if (conf.get("crunch.combine.file.block.size") != null) {
                this.setMaxSplitSize(conf.getLong("crunch.combine.file.block.size", 0L));
            } else {
                this.setMaxSplitSize(jobContext.getConfiguration().getLong("dfs.block.size", 0x8000000L));
            }
        }
    }

    public RecordReader createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        throw new UnsupportedOperationException("CrunchCombineFileInputFormat.createRecordReader should never be called");
    }
}

