/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.specific.SpecificRecord;
import org.apache.crunch.Source;
import org.apache.crunch.TableSource;
import org.apache.crunch.io.avro.AvroFileSource;
import org.apache.crunch.io.impl.FileTableSourceImpl;
import org.apache.crunch.io.seq.SeqFileSource;
import org.apache.crunch.io.seq.SeqFileTableSource;
import org.apache.crunch.io.text.TextFileSource;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class From {
    public static <K extends Writable, V extends Writable> TableSource<K, V> formattedFile(String pathName, Class<? extends FileInputFormat<K, V>> formatClass, Class<K> keyClass, Class<V> valueClass) {
        return From.formattedFile(new Path(pathName), formatClass, keyClass, valueClass);
    }

    public static <K extends Writable, V extends Writable> TableSource<K, V> formattedFile(Path path, Class<? extends FileInputFormat<K, V>> formatClass, Class<K> keyClass, Class<V> valueClass) {
        return From.formattedFile(path, formatClass, Writables.writables(keyClass), Writables.writables(valueClass));
    }

    public static <K extends Writable, V extends Writable> TableSource<K, V> formattedFile(List<Path> paths, Class<? extends FileInputFormat<K, V>> formatClass, Class<K> keyClass, Class<V> valueClass) {
        return From.formattedFile(paths, formatClass, Writables.writables(keyClass), Writables.writables(valueClass));
    }

    public static <K, V> TableSource<K, V> formattedFile(String pathName, Class<? extends FileInputFormat<?, ?>> formatClass, PType<K> keyType, PType<V> valueType) {
        return From.formattedFile(new Path(pathName), formatClass, keyType, valueType);
    }

    public static <K, V> TableSource<K, V> formattedFile(Path path, Class<? extends FileInputFormat<?, ?>> formatClass, PType<K> keyType, PType<V> valueType) {
        PTableType<K, V> tableType = keyType.getFamily().tableOf(keyType, valueType);
        return new FileTableSourceImpl<K, V>(path, tableType, formatClass);
    }

    public static <K, V> TableSource<K, V> formattedFile(List<Path> paths, Class<? extends FileInputFormat<?, ?>> formatClass, PType<K> keyType, PType<V> valueType) {
        PTableType<K, V> tableType = keyType.getFamily().tableOf(keyType, valueType);
        return new FileTableSourceImpl<K, V>(paths, tableType, formatClass);
    }

    public static <T extends SpecificRecord> Source<T> avroFile(String pathName, Class<T> avroClass) {
        return From.avroFile(new Path(pathName), avroClass);
    }

    public static <T extends SpecificRecord> Source<T> avroFile(Path path, Class<T> avroClass) {
        return From.avroFile(path, Avros.specifics(avroClass));
    }

    public static <T extends SpecificRecord> Source<T> avroFile(List<Path> paths, Class<T> avroClass) {
        return From.avroFile(paths, Avros.specifics(avroClass));
    }

    public static <T> Source<T> avroFile(String pathName, PType<T> ptype) {
        return From.avroFile(new Path(pathName), ptype);
    }

    public static <T> Source<T> avroFile(Path path, PType<T> ptype) {
        return new AvroFileSource(path, (AvroType)ptype);
    }

    public static <T> Source<T> avroFile(List<Path> paths, PType<T> ptype) {
        return new AvroFileSource(paths, (AvroType)ptype);
    }

    public static Source<GenericData.Record> avroFile(String pathName) {
        return From.avroFile(new Path(pathName));
    }

    public static Source<GenericData.Record> avroFile(Path path) {
        return From.avroFile(path, new Configuration());
    }

    public static Source<GenericData.Record> avroFile(List<Path> paths) {
        return From.avroFile(paths, new Configuration());
    }

    public static Source<GenericData.Record> avroFile(Path path, Configuration conf) {
        return From.avroFile(path, Avros.generics(From.getSchemaFromPath(path, conf)));
    }

    public static Source<GenericData.Record> avroFile(List<Path> paths, Configuration conf) {
        return From.avroFile(paths, Avros.generics(From.getSchemaFromPath(paths.get(0), conf)));
    }

    static Schema getSchemaFromPath(Path path, Configuration conf) {
        DataFileReader reader = null;
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (!fs.isFile(path)) {
                FileStatus[] fstat = fs.listStatus(path, new PathFilter(){

                    public boolean accept(Path path) {
                        String name = path.getName();
                        return !name.startsWith("_") && !name.startsWith(".");
                    }
                });
                if (fstat == null || fstat.length == 0) {
                    throw new IllegalArgumentException("No valid files found in directory: " + path);
                }
                path = fstat[0].getPath();
            }
            reader = new DataFileReader((SeekableInput)new FsInput(path, conf), (DatumReader)new GenericDatumReader());
            Schema schema = reader.getSchema();
            return schema;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading schema from path: " + path, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static <T extends Writable> Source<T> sequenceFile(String pathName, Class<T> valueClass) {
        return From.sequenceFile(new Path(pathName), valueClass);
    }

    public static <T extends Writable> Source<T> sequenceFile(Path path, Class<T> valueClass) {
        return From.sequenceFile(path, Writables.writables(valueClass));
    }

    public static <T extends Writable> Source<T> sequenceFile(List<Path> paths, Class<T> valueClass) {
        return From.sequenceFile(paths, Writables.writables(valueClass));
    }

    public static <T> Source<T> sequenceFile(String pathName, PType<T> ptype) {
        return From.sequenceFile(new Path(pathName), ptype);
    }

    public static <T> Source<T> sequenceFile(Path path, PType<T> ptype) {
        return new SeqFileSource<T>(path, ptype);
    }

    public static <T> Source<T> sequenceFile(List<Path> paths, PType<T> ptype) {
        return new SeqFileSource<T>(paths, ptype);
    }

    public static <K extends Writable, V extends Writable> TableSource<K, V> sequenceFile(String pathName, Class<K> keyClass, Class<V> valueClass) {
        return From.sequenceFile(new Path(pathName), keyClass, valueClass);
    }

    public static <K extends Writable, V extends Writable> TableSource<K, V> sequenceFile(Path path, Class<K> keyClass, Class<V> valueClass) {
        return From.sequenceFile(path, Writables.writables(keyClass), Writables.writables(valueClass));
    }

    public static <K extends Writable, V extends Writable> TableSource<K, V> sequenceFile(List<Path> paths, Class<K> keyClass, Class<V> valueClass) {
        return From.sequenceFile(paths, Writables.writables(keyClass), Writables.writables(valueClass));
    }

    public static <K, V> TableSource<K, V> sequenceFile(String pathName, PType<K> keyType, PType<V> valueType) {
        return From.sequenceFile(new Path(pathName), keyType, valueType);
    }

    public static <K, V> TableSource<K, V> sequenceFile(Path path, PType<K> keyType, PType<V> valueType) {
        PTypeFamily ptf = keyType.getFamily();
        return new SeqFileTableSource<K, V>(path, ptf.tableOf(keyType, valueType));
    }

    public static <K, V> TableSource<K, V> sequenceFile(List<Path> paths, PType<K> keyType, PType<V> valueType) {
        PTypeFamily ptf = keyType.getFamily();
        return new SeqFileTableSource<K, V>(paths, ptf.tableOf(keyType, valueType));
    }

    public static Source<String> textFile(String pathName) {
        return From.textFile(new Path(pathName));
    }

    public static Source<String> textFile(Path path) {
        return From.textFile(path, Writables.strings());
    }

    public static Source<String> textFile(List<Path> paths) {
        return From.textFile(paths, Writables.strings());
    }

    public static <T> Source<T> textFile(String pathName, PType<T> ptype) {
        return From.textFile(new Path(pathName), ptype);
    }

    public static <T> Source<T> textFile(Path path, PType<T> ptype) {
        return new TextFileSource<T>(path, ptype);
    }

    public static <T> Source<T> textFile(List<Path> paths, PType<T> ptype) {
        return new TextFileSource<T>(paths, ptype);
    }
}

