/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.MapFn;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.AutoClosingIterator;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AvroFileReaderFactory<T>
implements FileReaderFactory<T> {
    private static final Log LOG = LogFactory.getLog(AvroFileReaderFactory.class);
    private DatumReader<T> reader;
    private final AvroType<?> atype;
    private final MapFn<T, T> mapFn;

    public AvroFileReaderFactory(Schema schema) {
        this(null, Avros.generics(schema));
    }

    public AvroFileReaderFactory(AvroType<?> atype) {
        this(null, atype);
    }

    public AvroFileReaderFactory(DatumReader<T> reader, AvroType<?> atype) {
        this.reader = reader;
        this.atype = atype;
        this.mapFn = atype.getInputMapFn();
    }

    static <T> DatumReader<T> createDatumReader(AvroType<T> atype) {
        return Avros.newReader(atype);
    }

    @Override
    public Iterator<T> read(FileSystem fs, Path path) {
        AvroMode mode = AvroMode.fromType(this.atype).withFactoryFromConfiguration(fs.getConf());
        DatumReader<T> recordReader = this.reader == null ? mode.getReader(this.atype.getSchema()) : this.reader;
        this.mapFn.initialize();
        try {
            FsInput fsi = new FsInput(path, fs.getConf());
            final DataFileReader reader = new DataFileReader((SeekableInput)fsi, recordReader);
            return new AutoClosingIterator((Closeable)reader, new UnmodifiableIterator<T>(){

                public boolean hasNext() {
                    return reader.hasNext();
                }

                public T next() {
                    return AvroFileReaderFactory.this.mapFn.map(reader.next());
                }
            });
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read avro file at path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
    }
}

