/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro;

import java.io.IOException;
import java.util.List;
import org.apache.avro.io.DatumReader;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.avro.AvroFileReaderFactory;
import org.apache.crunch.io.avro.AvroReadableData;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.types.avro.AvroInputFormat;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;

public class AvroFileSource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private DatumReader<T> reader;

    private static <S> FormatBundle getBundle(AvroType<S> ptype, AvroMode mode) {
        FormatBundle<AvroInputFormat> bundle = FormatBundle.forInput(AvroInputFormat.class).set("avro.input.is.reflect", String.valueOf(ptype.hasReflect())).set("avro.input.schema", ptype.getSchema().toString()).set("crunch.reflectdatafactory", Avros.REFLECT_DATA_FACTORY.getClass().getName()).set("crunch.disable.combine.file", Boolean.FALSE.toString());
        mode.configure(bundle);
        return bundle;
    }

    private static <S> FormatBundle getBundle(AvroType<S> ptype) {
        return AvroFileSource.getBundle(ptype, AvroMode.fromType(ptype));
    }

    public AvroFileSource(Path path, AvroType<T> ptype) {
        super(path, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype));
    }

    public AvroFileSource(Path path, AvroType<T> ptype, AvroMode mode) {
        super(path, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype, mode));
    }

    public AvroFileSource(Path path, AvroType<T> ptype, DatumReader<T> reader) {
        super(path, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype));
        this.reader = reader;
    }

    public AvroFileSource(List<Path> paths, AvroType<T> ptype) {
        super(paths, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype));
    }

    public AvroFileSource(List<Path> paths, AvroType<T> ptype, AvroMode mode) {
        super(paths, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype, mode));
    }

    public AvroFileSource(List<Path> paths, AvroType<T> ptype, DatumReader<T> reader) {
        super(paths, ptype, (FormatBundle<? extends InputFormat>)AvroFileSource.getBundle(ptype));
        this.reader = reader;
    }

    @Override
    public String toString() {
        return "Avro(" + this.pathsAsString() + ")";
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, this.getFileReaderFactory((AvroType)this.ptype));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new AvroReadableData(this.paths, (AvroType)this.ptype);
    }

    protected AvroFileReaderFactory<T> getFileReaderFactory(AvroType<T> ptype) {
        return new AvroFileReaderFactory<T>(this.reader, ptype);
    }
}

