/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro.trevni;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.MapFn;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.AutoClosingIterator;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.trevni.Input;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.HadoopInput;

public class TrevniFileReaderFactory<T>
implements FileReaderFactory<T> {
    private static final Log LOG = LogFactory.getLog(TrevniFileReaderFactory.class);
    private final AvroType<T> aType;
    private final MapFn<T, T> mapFn;
    private final Schema schema;

    public TrevniFileReaderFactory(AvroType<T> atype) {
        this.aType = atype;
        this.schema = atype.getSchema();
        this.mapFn = atype.getInputMapFn();
    }

    public TrevniFileReaderFactory(Schema schema) {
        this.aType = null;
        this.schema = schema;
        this.mapFn = IdentityFn.getInstance();
    }

    static <T> AvroColumnReader<T> getReader(Input input, AvroType<T> avroType, Schema schema) {
        AvroColumnReader.Params params = new AvroColumnReader.Params(input);
        params.setSchema(schema);
        if (avroType.hasReflect()) {
            if (avroType.hasSpecific()) {
                Avros.checkCombiningSpecificAndReflectionSchemas();
            }
            params.setModel((GenericData)ReflectData.get());
        } else if (avroType.hasSpecific()) {
            params.setModel((GenericData)SpecificData.get());
        } else {
            params.setModel(GenericData.get());
        }
        try {
            return new AvroColumnReader(params);
        }
        catch (IOException e) {
            throw new CrunchRuntimeException(e);
        }
    }

    @Override
    public Iterator<T> read(FileSystem fs, Path path) {
        this.mapFn.initialize();
        try {
            HadoopInput input = new HadoopInput(path, fs.getConf());
            final AvroColumnReader<T> reader = TrevniFileReaderFactory.getReader((Input)input, this.aType, this.schema);
            return new AutoClosingIterator((Closeable)reader, new UnmodifiableIterator<T>(){

                public boolean hasNext() {
                    return reader.hasNext();
                }

                public T next() {
                    return TrevniFileReaderFactory.this.mapFn.map(reader.next());
                }
            });
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read avro file at path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
    }
}

