/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro.trevni;

import java.io.IOException;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroKeyComparator;
import org.apache.avro.hadoop.io.AvroSerialization;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.io.CrunchOutputs;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.avro.trevni.TrevniKeySourceTarget;
import org.apache.crunch.io.avro.trevni.TrevniOutputFormat;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.StringUtils;

public class TrevniKeyTarget
extends FileTargetImpl {
    public TrevniKeyTarget(String path) {
        this(new Path(path));
    }

    public TrevniKeyTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public TrevniKeyTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, TrevniOutputFormat.class, fileNamingScheme);
    }

    @Override
    public String toString() {
        return "TrevniKey(" + this.path.toString() + ")";
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        if (!(ptype instanceof AvroType)) {
            return false;
        }
        handler.configure(this, ptype);
        return true;
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        AvroType atype = (AvroType)ptype;
        Configuration conf = job.getConfiguration();
        if (null == name) {
            AvroJob.setOutputKeySchema((Job)job, (Schema)atype.getSchema());
            AvroJob.setMapOutputKeySchema((Job)job, (Schema)atype.getSchema());
            Avros.configureReflectDataFactory(conf);
            this.configureForMapReduce(job, AvroKey.class, NullWritable.class, FormatBundle.forOutput(TrevniOutputFormat.class), outputPath, null);
        } else {
            FormatBundle<TrevniOutputFormat> bundle = FormatBundle.forOutput(TrevniOutputFormat.class);
            bundle.set("avro.schema.output.key", atype.getSchema().toString());
            bundle.set("mapred.output.value.groupfn.class", AvroKeyComparator.class.getName());
            bundle.set("mapred.output.key.comparator.class", AvroKeyComparator.class.getName());
            bundle.set("avro.serialization.key.writer.schema", atype.getSchema().toString());
            bundle.set("avro.serialization.key.reader.schema", atype.getSchema().toString());
            Collection serializations = conf.getStringCollection("io.serializations");
            if (!serializations.contains(AvroSerialization.class.getName())) {
                serializations.add(AvroSerialization.class.getName());
                bundle.set(name, StringUtils.arrayToString((String[])serializations.toArray(new String[serializations.size()])));
            }
            bundle.set("crunch.reflectdatafactory", Avros.REFLECT_DATA_FACTORY.getClass().getName());
            bundle.set("mapred.output.dir", new Path(outputPath, name).toString());
            try {
                FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            }
            catch (Exception ioe) {
                throw new RuntimeException(ioe);
            }
            CrunchOutputs.addNamedOutput(job, name, bundle, AvroKey.class, NullWritable.class);
        }
    }

    @Override
    protected Path getSourcePattern(Path workingPath, int index) {
        return new Path(workingPath, "out" + index + "*/part-*/part-*");
    }

    @Override
    protected Path getDestFile(Configuration conf, Path src, Path dir, boolean mapOnlyJob) throws IOException {
        Path outputFilename = super.getDestFile(conf, src, dir, true);
        return new Path(outputFilename.toString() + "-" + src.getName());
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (ptype instanceof AvroType) {
            return new TrevniKeySourceTarget(this.path, (AvroType)ptype);
        }
        return null;
    }
}

