/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.ReadableData;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.io.CompositePathIterable;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.util.DistCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public abstract class ReadableDataImpl<T>
implements ReadableData<T> {
    private List<String> paths = Lists.newArrayList();
    private transient SourceTarget parent;

    protected ReadableDataImpl(List<Path> paths) {
        for (Path p : paths) {
            this.paths.add(p.toString());
        }
    }

    public ReadableData<T> setParent(SourceTarget<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Set<SourceTarget<?>> getSourceTargets() {
        if (this.parent != null) {
            return ImmutableSet.of((Object)this.parent);
        }
        return ImmutableSet.of();
    }

    @Override
    public void configure(Configuration conf) {
        for (String path : this.paths) {
            DistCache.addCacheFile(new Path(path), conf);
        }
    }

    protected abstract FileReaderFactory<T> getFileReaderFactory();

    private Path getCacheFilePath(String input, Configuration conf) {
        Path local = DistCache.getPathToCacheFile(new Path(input), conf);
        if (local == null) {
            throw new CrunchRuntimeException("Can't find local cache file for '" + input + "'");
        }
        return local;
    }

    @Override
    public Iterable<T> read(TaskInputOutputContext<?, ?, ?, ?> ctxt) throws IOException {
        final Configuration conf = ctxt.getConfiguration();
        final FileReaderFactory<T> readerFactory = this.getFileReaderFactory();
        return Iterables.concat((Iterable)Lists.transform(this.paths, (Function)new Function<String, Iterable<T>>(){

            public Iterable<T> apply(@Nullable String input) {
                Path path = ReadableDataImpl.this.getCacheFilePath(input, conf);
                try {
                    FileSystem fs = path.getFileSystem(conf);
                    return CompositePathIterable.create(fs, path, readerFactory);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }
}

