/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.parquet.AvroParquetConverter;
import org.apache.crunch.io.parquet.AvroParquetFileReaderFactory;
import org.apache.crunch.io.parquet.AvroParquetReadableData;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;

public class AvroParquetFileSource<T extends IndexedRecord>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private final String projSchema;

    private static <S> FormatBundle<AvroParquetInputFormat> getBundle(AvroType<S> ptype, Schema extSchema, Class<? extends UnboundRecordFilter> filterClass) {
        Schema schema = extSchema == null ? ptype.getSchema() : extSchema;
        FormatBundle<AvroParquetInputFormat> fb = FormatBundle.forInput(AvroParquetInputFormat.class).set(AvroReadSupport.AVRO_REQUESTED_PROJECTION, schema.toString()).set("crunch.disable.combine.file", "true");
        if (filterClass != null) {
            fb.set("parquet.read.filter", filterClass.getName());
        }
        return fb;
    }

    public AvroParquetFileSource(Path path, AvroType<T> ptype) {
        this((List<Path>)ImmutableList.of((Object)path), ptype);
    }

    public AvroParquetFileSource(Path path, AvroType<T> ptype, Schema schema) {
        this((List<Path>)ImmutableList.of((Object)path), ptype, schema);
    }

    public AvroParquetFileSource(List<Path> paths, AvroType<T> ptype) {
        this(paths, ptype, null, null);
    }

    public AvroParquetFileSource(List<Path> paths, AvroType<T> ptype, Schema schema) {
        this(paths, ptype, schema, null);
    }

    public AvroParquetFileSource(List<Path> paths, AvroType<T> ptype, Class<? extends UnboundRecordFilter> filterClass) {
        this(paths, ptype, null, filterClass);
    }

    public AvroParquetFileSource(List<Path> paths, AvroType<T> ptype, Schema schema, Class<? extends UnboundRecordFilter> filterClass) {
        super(paths, ptype, AvroParquetFileSource.getBundle(ptype, schema, filterClass));
        this.projSchema = schema == null ? null : schema.toString();
    }

    public Schema getProjectedSchema() {
        return new Schema.Parser().parse(this.projSchema);
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, this.getFileReaderFactory((AvroType)this.ptype));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new AvroParquetReadableData(this.paths, (AvroType)this.ptype);
    }

    protected AvroParquetFileReaderFactory<T> getFileReaderFactory(AvroType<T> ptype) {
        return new AvroParquetFileReaderFactory<T>(ptype);
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter() {
        return new AvroParquetConverter((AvroType)this.ptype);
    }

    @Override
    public String toString() {
        return "Parquet(" + this.pathsAsString() + (this.projSchema == null ? ")" : ") -> " + this.projSchema);
    }

    public static <T extends SpecificRecord> Builder<T> builder(Class<T> clazz) {
        return new Builder((Class)Preconditions.checkNotNull(clazz));
    }

    public static Builder<GenericRecord> builder(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)schema.getType()));
        return new Builder<GenericRecord>(schema);
    }

    public static class Builder<T extends IndexedRecord> {
        private Class<T> clazz;
        private Schema baseSchema;
        private List<Schema.Field> fields = Lists.newArrayList();
        private Class<? extends UnboundRecordFilter> filterClass;

        private Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.baseSchema = ((IndexedRecord)ReflectionUtils.newInstance(clazz, null)).getSchema();
        }

        private Builder(Schema baseSchema) {
            this.baseSchema = baseSchema;
        }

        public Builder includeField(String fieldName) {
            Schema.Field field = this.baseSchema.getField(fieldName);
            if (field == null) {
                throw new IllegalArgumentException("No field " + fieldName + " in schema: " + this.baseSchema.getName());
            }
            this.fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
            return this;
        }

        public Builder filterClass(Class<? extends UnboundRecordFilter> filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        public AvroParquetFileSource<T> build(Path path) {
            return this.build((List<Path>)ImmutableList.of((Object)path));
        }

        public AvroParquetFileSource<T> build(List<Path> paths) {
            AvroType<Object> at;
            AvroType<Object> avroType = at = this.clazz == null ? Avros.generics(this.baseSchema) : Avros.specifics(this.clazz);
            if (this.fields.isEmpty()) {
                return new AvroParquetFileSource<GenericData.Record>(paths, at, this.filterClass);
            }
            Schema projected = Schema.createRecord((String)this.baseSchema.getName(), (String)this.baseSchema.getDoc(), (String)this.baseSchema.getNamespace(), (boolean)this.baseSchema.isError());
            projected.setFields(this.fields);
            return new AvroParquetFileSource<GenericData.Record>(paths, at, projected, this.filterClass);
        }
    }
}

