/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.seq;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.MapFn;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.AutoClosingIterator;
import org.apache.crunch.io.seq.SeqFileHelper;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class SeqFileReaderFactory<T>
implements FileReaderFactory<T> {
    private static final Log LOG = LogFactory.getLog(SeqFileReaderFactory.class);
    private final Converter converter;
    private final MapFn<Object, T> mapFn;
    private final Writable key;
    private final Writable value;

    public SeqFileReaderFactory(PType<T> ptype) {
        this.converter = ptype.getConverter();
        this.mapFn = ptype.getInputMapFn();
        if (ptype instanceof PTableType) {
            PTableType ptt = (PTableType)ptype;
            this.key = SeqFileHelper.newInstance(ptt.getKeyType(), null);
            this.value = SeqFileHelper.newInstance(ptt.getValueType(), null);
        } else {
            this.key = NullWritable.get();
            this.value = SeqFileHelper.newInstance(ptype, null);
        }
    }

    public SeqFileReaderFactory(Class clazz) {
        WritableType ptype = Writables.writables(clazz);
        this.converter = ptype.getConverter();
        this.mapFn = ptype.getInputMapFn();
        this.key = NullWritable.get();
        this.value = (Writable)ReflectionUtils.newInstance((Class)clazz, null);
    }

    @Override
    public Iterator<T> read(FileSystem fs, final Path path) {
        this.mapFn.initialize();
        try {
            final SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, fs.getConf());
            return new AutoClosingIterator((Closeable)reader, new UnmodifiableIterator<T>(){
                boolean nextChecked = false;
                boolean hasNext = false;

                public boolean hasNext() {
                    if (this.nextChecked) {
                        return this.hasNext;
                    }
                    try {
                        this.hasNext = reader.next(SeqFileReaderFactory.this.key, SeqFileReaderFactory.this.value);
                        this.nextChecked = true;
                        return this.hasNext;
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Error reading from path: " + path), (Throwable)e);
                        return false;
                    }
                }

                public T next() {
                    if (!this.nextChecked && !this.hasNext()) {
                        return null;
                    }
                    this.nextChecked = false;
                    return SeqFileReaderFactory.this.mapFn.map(SeqFileReaderFactory.this.converter.convertInput(SeqFileReaderFactory.this.key, SeqFileReaderFactory.this.value));
                }
            });
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read seqfile at path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
    }
}

