/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileTableSourceImpl;
import org.apache.crunch.io.text.LineParser;
import org.apache.crunch.io.text.TextFileReaderFactory;
import org.apache.crunch.io.text.TextReadableData;
import org.apache.crunch.types.PTableType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;

public class TextFileTableSource<K, V>
extends FileTableSourceImpl<K, V>
implements ReadableSource<Pair<K, V>> {
    private static final String OLD_KV_SEP = "key.value.separator.in.input.line";
    private static final String NEW_KV_SEP = "mapreduce.input.keyvaluelinerecordreader.key.value.separator";
    private final String separator;

    private static FormatBundle getBundle(String sep) {
        FormatBundle<KeyValueTextInputFormat> bundle = FormatBundle.forInput(KeyValueTextInputFormat.class);
        bundle.set(OLD_KV_SEP, sep);
        bundle.set(NEW_KV_SEP, sep);
        return bundle;
    }

    public TextFileTableSource(String path, PTableType<K, V> tableType) {
        this(new Path(path), tableType);
    }

    public TextFileTableSource(Path path, PTableType<K, V> tableType) {
        this(path, tableType, "\t");
    }

    public TextFileTableSource(List<Path> paths, PTableType<K, V> tableType) {
        this(paths, tableType, "\t");
    }

    public TextFileTableSource(String path, PTableType<K, V> tableType, String separator) {
        this(new Path(path), tableType, separator);
    }

    public TextFileTableSource(Path path, PTableType<K, V> tableType, String separator) {
        super(path, tableType, TextFileTableSource.getBundle(separator));
        this.separator = separator;
    }

    public TextFileTableSource(List<Path> paths, PTableType<K, V> tableType, String separator) {
        super(paths, tableType, TextFileTableSource.getBundle(separator));
        this.separator = separator;
    }

    @Override
    public String toString() {
        return "KeyValueText(" + this.pathsAsString() + ")";
    }

    @Override
    public Iterable<Pair<K, V>> read(Configuration conf) throws IOException {
        return this.read(conf, new TextFileReaderFactory(LineParser.forTableType(this.getTableType(), this.separator)));
    }

    @Override
    public ReadableData<Pair<K, V>> asReadable() {
        return new TextReadableData<Pair<K, V>>(this.paths, this.getTableType(), this.separator);
    }
}

