/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.text.csv.CSVRecordIterator;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CSVFileReaderFactory
implements FileReaderFactory<String> {
    private static final Log LOG = LogFactory.getLog(CSVFileReaderFactory.class);
    private int bufferSize;
    private String inputFileEncoding;
    private char openQuoteChar;
    private char closeQuoteChar;
    private char escapeChar;

    CSVFileReaderFactory() {
        this(65536, "UTF-8", '\"', '\"', '\\');
    }

    CSVFileReaderFactory(int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar) {
        this.bufferSize = bufferSize;
        this.inputFileEncoding = inputFileEncoding;
        this.openQuoteChar = openQuoteChar;
        this.closeQuoteChar = closeQuoteChar;
        this.escapeChar = escapeChar;
    }

    @Override
    public Iterator<String> read(FileSystem fs, Path path) {
        try {
            FSDataInputStream is = fs.open(path);
            return new CSVRecordIterator((InputStream)is, this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar);
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
    }
}

