/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.crunch.io.text.csv.CSVLineReader;
import org.apache.crunch.io.text.csv.CSVRecordReader;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CSVInputFormat
extends FileInputFormat<LongWritable, Text> {
    private int bufferSize;
    private String inputFileEncoding;
    private char openQuoteChar;
    private char closeQuoteChar;
    private char escapeChar;

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new CSVRecordReader(this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long splitSize = job.getConfiguration().getLong("csv.input.split.size", 0x4000000L);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Path[] paths = FileUtil.stat2Paths((FileStatus[])this.listStatus(job).toArray(new FileStatus[0]));
        FileSystem fileSystem = null;
        FSDataInputStream inputStream = null;
        try {
            for (Path path : paths) {
                fileSystem = path.getFileSystem(job.getConfiguration());
                inputStream = fileSystem.open(path);
                splits.addAll(this.getSplitsForFile(splitSize, fileSystem.getFileStatus(path).getLen(), path, inputStream));
            }
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        finally {
            inputStream.close();
        }
    }

    @VisibleForTesting
    protected List<FileSplit> getSplitsForFile(long splitSize, long fileSize, Path fileName, FSDataInputStream inputStream) throws IOException {
        ArrayList<FileSplit> splitsList = new ArrayList<FileSplit>();
        long currentPosition = 0L;
        boolean endOfFile = false;
        while (!endOfFile) {
            int bytesRead;
            long splitStart = currentPosition;
            if ((currentPosition = splitStart + splitSize) >= fileSize) {
                currentPosition = fileSize;
                endOfFile = true;
                FileSplit fileSplit = new FileSplit(fileName, splitStart, currentPosition - splitStart, new String[0]);
                splitsList.add(fileSplit);
                break;
            }
            inputStream.seek(currentPosition);
            CSVLineReader csvLineReader = new CSVLineReader((InputStream)inputStream, this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar);
            currentPosition += (long)csvLineReader.readFileLine(new Text());
            csvLineReader.resetMultiLine();
            currentPosition += (long)csvLineReader.readFileLine(new Text());
            while (csvLineReader.isInMultiLine() && (bytesRead = csvLineReader.readFileLine(new Text())) > 0) {
                currentPosition += (long)bytesRead;
            }
            splitsList.add(new FileSplit(fileName, splitStart, currentPosition - splitStart, new String[0]));
        }
        return splitsList;
    }

    public void configure(JobConf jobConf) {
        String bufferValue = jobConf.get("csv.buffersize");
        this.bufferSize = "".equals(bufferValue) ? 65536 : Integer.parseInt(bufferValue);
        String inputFileEncodingValue = jobConf.get("csv.inputfileencoding");
        this.inputFileEncoding = "".equals(inputFileEncodingValue) ? "UTF-8" : inputFileEncodingValue;
        String openQuoteCharValue = jobConf.get("csv.openquotechar");
        this.openQuoteChar = "".equals(openQuoteCharValue) ? (char)34 : openQuoteCharValue.charAt(0);
        String closeQuoteCharValue = jobConf.get("csv.closequotechar");
        this.closeQuoteChar = "".equals(closeQuoteCharValue) ? (char)34 : closeQuoteCharValue.charAt(0);
        String escapeCharValue = jobConf.get("csv.escapechar");
        this.escapeChar = "".equals(escapeCharValue) ? (char)92 : escapeCharValue.charAt(0);
    }
}

