/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.crunch.io.text.csv.CSVLineReader;
import org.apache.hadoop.io.Text;

public class CSVRecordIterator
implements Iterator<String>,
Closeable {
    private CSVLineReader csvLineReader;
    private InputStream inputStream;
    private String currentLine;

    public CSVRecordIterator(InputStream inputStream) throws UnsupportedEncodingException {
        this(inputStream, 65536, "UTF-8", '\"', '\"', '\\');
    }

    public CSVRecordIterator(InputStream inputStream, int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar) throws UnsupportedEncodingException {
        this.csvLineReader = new CSVLineReader(inputStream, bufferSize, inputFileEncoding, openQuoteChar, closeQuoteChar, escapeChar);
        this.inputStream = inputStream;
        this.incrementValue();
    }

    @Override
    public boolean hasNext() {
        if (this.currentLine != null) {
            return true;
        }
        Closeables.closeQuietly((Closeable)this);
        return false;
    }

    @Override
    public String next() {
        String result = this.currentLine;
        this.incrementValue();
        return result;
    }

    @Override
    public void remove() {
        this.incrementValue();
    }

    private void incrementValue() {
        Text tempText = new Text();
        try {
            this.csvLineReader.readCSVLine(tempText);
        }
        catch (IOException e) {
            throw new RuntimeException("A problem occurred accessing the underlying CSV file stream.", e);
        }
        String tempTextAsString = tempText.toString();
        this.currentLine = "".equals(tempTextAsString) ? null : tempTextAsString;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

