/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.crunch.io.text.csv.CSVLineReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVRecordReader
extends RecordReader<LongWritable, Text> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVRecordReader.class);
    private long start;
    private long pos;
    private long end;
    private LongWritable key = null;
    private Text value = null;
    private FSDataInputStream fileIn;
    private CSVLineReader csvLineReader;
    private final char openQuote;
    private final char closeQuote;
    private final char escape;
    private final String inputFileEncoding;
    private final int fileStreamBufferSize;
    private int totalRecordsRead = 0;

    public CSVRecordReader() {
        this(65536, "UTF-8", '\"', '\"', '\\');
    }

    public CSVRecordReader(int bufferSize, String inputFileEncoding, char openQuote, char closeQuote, char escape) {
        Preconditions.checkNotNull((Object)Character.valueOf(openQuote), (Object)"quote cannot be null.");
        Preconditions.checkNotNull((Object)Character.valueOf(closeQuote), (Object)"quote cannot be null.");
        Preconditions.checkNotNull((Object)Character.valueOf(escape), (Object)"escape cannot be null.");
        this.fileStreamBufferSize = bufferSize;
        this.inputFileEncoding = inputFileEncoding;
        this.openQuote = openQuote;
        this.closeQuote = closeQuote;
        this.escape = escape;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        this.pos = this.start;
        Path file = split.getPath();
        LOGGER.info("Initializing processing of split for file: " + file);
        LOGGER.info("File size is: " + file.getFileSystem(job).getFileStatus(file).getLen());
        LOGGER.info("Split starts at: " + this.start);
        LOGGER.info("Split will end at: " + this.end);
        this.fileIn = file.getFileSystem(job).open(file);
        this.fileIn.seek(this.start);
        this.csvLineReader = new CSVLineReader((InputStream)this.fileIn, this.fileStreamBufferSize, this.inputFileEncoding, this.openQuote, this.closeQuote, this.escape);
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new LongWritable();
        }
        this.key.set(this.pos);
        if (this.value == null) {
            this.value = new Text();
        }
        if (this.pos >= this.end) {
            this.key = null;
            this.value = null;
            LOGGER.info("End of split reached, ending processing. Total records read for this split: " + this.totalRecordsRead);
            this.close();
            return false;
        }
        int newSize = this.csvLineReader.readCSVLine(this.value);
        if (newSize == 0) {
            LOGGER.info("End of file reached. Ending processing. Total records read for this split: " + this.totalRecordsRead);
            return false;
        }
        this.pos += (long)newSize;
        ++this.totalRecordsRead;
        return true;
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public Text getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        this.fileIn.close();
    }
}

