/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib;

import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;

public class Shard {
    public static <T> PCollection<T> shard(PCollection<T> pc, int numPartitions) {
        return pc.by(new ShardFn(), pc.getTypeFamily().ints()).groupByKey(numPartitions).ungroup().values();
    }

    private static class ShardFn<T>
    extends MapFn<T, Integer> {
        private int count;

        private ShardFn() {
        }

        @Override
        public void initialize() {
            this.count = 0;
        }

        @Override
        public Integer map(T input) {
            return this.count++;
        }
    }
}

