/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.join;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.crunch.Emitter;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.join.JoinFn;
import org.apache.crunch.types.PType;

public class FullOuterJoinFn<K, U, V>
extends JoinFn<K, U, V> {
    private transient int lastId;
    private transient K lastKey;
    private transient List<U> leftValues;

    public FullOuterJoinFn(PType<K> keyType, PType<U> leftValueType) {
        super(keyType, leftValueType);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.lastId = 1;
        this.lastKey = null;
        this.leftValues = Lists.newArrayList();
    }

    @Override
    public void join(K key, int id, Iterable<Pair<U, V>> pairs, Emitter<Pair<K, Pair<U, V>>> emitter) {
        if (!key.equals(this.lastKey)) {
            if (0 == this.lastId) {
                for (Pair<Object, V> pair : this.leftValues) {
                    emitter.emit(Pair.of(this.lastKey, Pair.of(pair, null)));
                }
            }
            this.lastKey = this.keyType.getDetachedValue(key);
            this.leftValues.clear();
        }
        if (id == 0) {
            for (Pair<Object, V> pair : pairs) {
                if (pair.first() == null) continue;
                this.leftValues.add(this.leftValueType.getDetachedValue(pair.first()));
            }
        } else {
            for (Pair<Object, V> pair : pairs) {
                if (this.leftValues.isEmpty()) {
                    this.leftValues.add(null);
                }
                for (U u : this.leftValues) {
                    emitter.emit(Pair.of(this.lastKey, Pair.of(u, pair.second())));
                }
            }
        }
        this.lastId = id;
    }

    @Override
    public void cleanup(Emitter<Pair<K, Pair<U, V>>> emitter) {
        if (0 == this.lastId) {
            for (U u : this.leftValues) {
                emitter.emit(Pair.of(this.lastKey, Pair.of(u, null)));
            }
        }
    }

    @Override
    public String getJoinType() {
        return "fullOuterJoin";
    }
}

