/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.join;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.PCollection;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.lib.join.DefaultJoinStrategy;
import org.apache.crunch.types.PType;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class OneToManyJoin {
    public static <K, U, V, T> PCollection<T> oneToManyJoin(PTable<K, U> left, PTable<K, V> right, DoFn<Pair<U, Iterable<V>>, T> postProcessFn, PType<T> ptype) {
        return OneToManyJoin.oneToManyJoin(left, right, postProcessFn, ptype, -1);
    }

    public static <K, U, V, T> PCollection<T> oneToManyJoin(PTable<K, U> left, PTable<K, V> right, DoFn<Pair<U, Iterable<V>>, T> postProcessFn, PType<T> ptype, int numReducers) {
        PGroupedTable<Pair<K, Integer>, Pair<U, V>> grouped = DefaultJoinStrategy.preJoin(left, right, numReducers);
        return grouped.parallelDo("One to many join " + grouped.getName(), new OneToManyJoinFn(left.getValueType(), postProcessFn), ptype);
    }

    static class OneToManyJoinFn<K, U, V, T>
    extends DoFn<Pair<Pair<K, Integer>, Iterable<Pair<U, V>>>, T> {
        private PType<U> leftValueType;
        private DoFn<Pair<U, Iterable<V>>, T> postProcessFn;
        private SecondElementFunction<U, V> secondElementFunction;
        private K currentKey;
        private U leftValue;

        public OneToManyJoinFn(PType<U> leftValueType, DoFn<Pair<U, Iterable<V>>, T> postProcessFn) {
            this.leftValueType = leftValueType;
            this.postProcessFn = postProcessFn;
            this.secondElementFunction = new SecondElementFunction();
        }

        @Override
        public void initialize() {
            super.initialize();
            this.postProcessFn.initialize();
            this.leftValueType.initialize(this.getConfiguration());
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            super.setContext(context);
            this.postProcessFn.setContext(context);
        }

        @Override
        public void process(Pair<Pair<K, Integer>, Iterable<Pair<U, V>>> input, Emitter<T> emitter) {
            Pair<K, Integer> keyPair = input.first();
            if (keyPair.second() == 0) {
                this.leftValue = this.leftValueType.getDetachedValue(input.second().iterator().next().first());
                this.currentKey = input.first().first();
            } else if (keyPair.second() == 1 && input.first().first().equals(this.currentKey)) {
                this.postProcessFn.process(Pair.of(this.leftValue, this.wrapIterable(input.second())), emitter);
                this.leftValue = null;
            }
        }

        private Iterable<V> wrapIterable(Iterable<Pair<U, V>> input) {
            return Iterables.transform(input, this.secondElementFunction);
        }

        private static class SecondElementFunction<U, V>
        implements Function<Pair<U, V>, V>,
        Serializable {
            private SecondElementFunction() {
            }

            public V apply(@Nullable Pair<U, V> input) {
                return input.second();
            }
        }
    }
}

