/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.materialize;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.Pipeline;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.io.PathTarget;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.hadoop.fs.Path;

public class MaterializableIterable<E>
implements Iterable<E> {
    private static final Log LOG = LogFactory.getLog(MaterializableIterable.class);
    private final Pipeline pipeline;
    private final ReadableSource<E> source;
    private Iterable<E> materialized;

    public MaterializableIterable(Pipeline pipeline, ReadableSource<E> source) {
        this.pipeline = pipeline;
        this.source = source;
        this.materialized = null;
    }

    public ReadableSource<E> getSource() {
        return this.source;
    }

    public boolean isSourceTarget() {
        return this.source instanceof SourceTarget;
    }

    public Path getPath() {
        if (this.source instanceof FileSourceImpl) {
            return ((FileSourceImpl)((Object)this.source)).getPath();
        }
        if (this.source instanceof PathTarget) {
            return ((PathTarget)((Object)this.source)).getPath();
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.materialized == null) {
            this.pipeline.run();
            this.materialize();
        }
        return this.materialized.iterator();
    }

    public void materialize() {
        try {
            this.materialized = this.source.read(this.pipeline.getConfiguration());
        }
        catch (IOException e) {
            LOG.error((Object)("Could not materialize: " + this.source), (Throwable)e);
            throw new CrunchRuntimeException(e);
        }
    }
}

