/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.crunch.Tuple;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.TupleFactory;
import org.apache.hadoop.conf.Configuration;

public class TupleDeepCopier<T extends Tuple>
implements DeepCopier<T> {
    private final TupleFactory<T> tupleFactory;
    private final List<PType> elementTypes;

    public TupleDeepCopier(Class<T> tupleClass, PType ... elementTypes) {
        this.tupleFactory = TupleFactory.getTupleFactory(tupleClass);
        this.elementTypes = Lists.newArrayList((Object[])elementTypes);
    }

    @Override
    public void initialize(Configuration conf) {
        for (PType elementType : this.elementTypes) {
            elementType.initialize(conf);
        }
    }

    @Override
    public T deepCopy(T source) {
        if (source == null) {
            return null;
        }
        Object[] deepCopyValues = new Object[source.size()];
        for (int valueIndex = 0; valueIndex < this.elementTypes.size(); ++valueIndex) {
            PType elementType = this.elementTypes.get(valueIndex);
            deepCopyValues[valueIndex] = elementType.getDetachedValue(source.get(valueIndex));
        }
        return this.tupleFactory.makeTuple(deepCopyValues);
    }
}

