/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import org.apache.crunch.MapFn;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.conf.Configuration;

public class AvroDerivedValueDeepCopier<T, S>
implements DeepCopier {
    private final MapFn<T, S> derivedToAvroFn;
    private final MapFn<S, T> avroToDerivedFn;
    private final AvroType<S> avroBaseType;

    public AvroDerivedValueDeepCopier(MapFn<T, S> derivedToAvroFn, MapFn<S, T> avroToDerivedFn, AvroType<S> avroBaseType) {
        this.derivedToAvroFn = derivedToAvroFn;
        this.avroToDerivedFn = avroToDerivedFn;
        this.avroBaseType = avroBaseType;
    }

    @Override
    public void initialize(Configuration conf) {
        this.avroBaseType.initialize(conf);
    }

    public Object deepCopy(Object source) {
        return this.avroToDerivedFn.map(this.avroBaseType.getDetachedValue(this.derivedToAvroFn.map(source)));
    }
}

