/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.MapFn;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.io.avro.AvroFileSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.avro.AvroKeyConverter;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class AvroType<T>
implements PType<T> {
    private static final Converter AVRO_CONVERTER = new AvroKeyConverter();
    private final Class<T> typeClass;
    private final String schemaString;
    private transient Schema schema;
    private final MapFn baseInputMapFn;
    private final MapFn baseOutputMapFn;
    private final List<PType> subTypes;
    private AvroRecordType recordType;
    private DeepCopier<T> deepCopier;
    private boolean initialized = false;

    public AvroType(Class<T> typeClass, Schema schema, DeepCopier<T> deepCopier, PType ... ptypes) {
        this(typeClass, schema, IdentityFn.getInstance(), IdentityFn.getInstance(), deepCopier, null, ptypes);
    }

    public AvroType(Class<T> typeClass, Schema schema, MapFn inputMapFn, MapFn outputMapFn, DeepCopier<T> deepCopier, AvroRecordType recordType, PType ... ptypes) {
        this.typeClass = typeClass;
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
        this.schemaString = schema.toString();
        this.baseInputMapFn = inputMapFn;
        this.baseOutputMapFn = outputMapFn;
        this.deepCopier = deepCopier;
        this.subTypes = ImmutableList.builder().add((Object[])ptypes).build();
        this.recordType = recordType;
    }

    private AvroRecordType determineRecordType() {
        if (this.checkReflect()) {
            return AvroRecordType.REFLECT;
        }
        if (this.checkSpecific()) {
            return AvroRecordType.SPECIFIC;
        }
        return AvroRecordType.GENERIC;
    }

    public AvroRecordType getRecordType() {
        if (this.recordType == null) {
            this.recordType = this.determineRecordType();
        }
        return this.recordType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public PTypeFamily getFamily() {
        return AvroTypeFamily.getInstance();
    }

    @Override
    public List<PType> getSubTypes() {
        return Lists.newArrayList(this.subTypes);
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema.Parser().parse(this.schemaString);
        }
        return this.schema;
    }

    public boolean hasSpecific() {
        return this.getRecordType() == AvroRecordType.SPECIFIC;
    }

    private boolean checkSpecific() {
        if (Avros.isPrimitive(this.typeClass)) {
            return false;
        }
        if (!this.subTypes.isEmpty()) {
            for (PType subType : this.subTypes) {
                if (!((AvroType)subType).hasSpecific()) continue;
                return true;
            }
            return false;
        }
        return SpecificRecord.class.isAssignableFrom(this.typeClass);
    }

    public boolean isGeneric() {
        return GenericData.Record.class.equals(this.typeClass);
    }

    public boolean hasReflect() {
        return this.getRecordType() == AvroRecordType.REFLECT;
    }

    private boolean checkReflect() {
        if (Avros.isPrimitive(this.typeClass)) {
            return false;
        }
        if (!this.subTypes.isEmpty()) {
            for (PType subType : this.subTypes) {
                if (!((AvroType)subType).hasReflect()) continue;
                return true;
            }
            return false;
        }
        return !this.typeClass.equals(GenericData.Record.class) && !SpecificRecord.class.isAssignableFrom(this.typeClass);
    }

    @Override
    public MapFn<Object, T> getInputMapFn() {
        return this.baseInputMapFn;
    }

    @Override
    public MapFn<T, Object> getOutputMapFn() {
        return this.baseOutputMapFn;
    }

    @Override
    public Converter getConverter() {
        return AVRO_CONVERTER;
    }

    @Override
    public ReadableSourceTarget<T> getDefaultFileSource(Path path) {
        return new AvroFileSourceTarget(path, this);
    }

    @Override
    public void initialize(Configuration conf) {
        this.baseInputMapFn.setConfiguration(conf);
        this.baseInputMapFn.initialize();
        this.baseOutputMapFn.setConfiguration(conf);
        this.baseOutputMapFn.initialize();
        this.deepCopier.initialize(conf);
        for (PType ptype : this.subTypes) {
            ptype.initialize(conf);
        }
        this.initialized = true;
    }

    @Override
    public T getDetachedValue(T value) {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot call getDetachedValue on an uninitialized PType");
        }
        return this.deepCopier.deepCopy(value);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AvroType)) {
            return false;
        }
        AvroType at = (AvroType)other;
        return this.typeClass.equals(at.typeClass) && ((Object)this.subTypes).equals(at.subTypes);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.typeClass).append(this.subTypes);
        return hcb.toHashCode();
    }

    public static enum AvroRecordType {
        REFLECT,
        SPECIFIC,
        GENERIC;

    }
}

