/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class UnionWritable
implements WritableComparable<UnionWritable> {
    private int index;
    private BytesWritable value;

    public UnionWritable() {
    }

    public UnionWritable(int index, BytesWritable value) {
        this.index = index;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public BytesWritable getValue() {
        return this.value;
    }

    public int compareTo(UnionWritable other) {
        if (this.index == other.getIndex()) {
            return this.value.compareTo((BinaryComparable)other.getValue());
        }
        return this.index - other.getIndex();
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.index);
        this.value.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.index = WritableUtils.readVInt((DataInput)in);
        if (this.value == null) {
            this.value = new BytesWritable();
        }
        this.value.readFields(in);
    }
}

