/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.fn.PairMapFn;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.io.seq.SeqFileTableSourceTarget;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.writable.WritableGroupedTableType;
import org.apache.crunch.types.writable.WritablePairConverter;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.WritableTypeFamily;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

class WritableTableType<K, V>
implements PTableType<K, V> {
    private final WritableType<K, Writable> keyType;
    private final WritableType<V, Writable> valueType;
    private final MapFn inputFn;
    private final MapFn outputFn;
    private final Converter converter;

    public WritableTableType(WritableType<K, Writable> keyType, WritableType<V, Writable> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.inputFn = new PairMapFn(keyType.getInputMapFn(), valueType.getInputMapFn());
        this.outputFn = new PairMapFn(keyType.getOutputMapFn(), valueType.getOutputMapFn());
        this.converter = new WritablePairConverter<Writable, Writable>(keyType.getSerializationClass(), valueType.getSerializationClass());
    }

    @Override
    public Class<Pair<K, V>> getTypeClass() {
        return Pair.of(null, null).getClass();
    }

    @Override
    public List<PType> getSubTypes() {
        return ImmutableList.of(this.keyType, this.valueType);
    }

    @Override
    public MapFn getInputMapFn() {
        return this.inputFn;
    }

    @Override
    public MapFn getOutputMapFn() {
        return this.outputFn;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public PTypeFamily getFamily() {
        return WritableTypeFamily.getInstance();
    }

    @Override
    public PType<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public PGroupedTableType<K, V> getGroupedTableType() {
        return new WritableGroupedTableType(this);
    }

    @Override
    public ReadableSourceTarget<Pair<K, V>> getDefaultFileSource(Path path) {
        return new SeqFileTableSourceTarget(path, this);
    }

    @Override
    public void initialize(Configuration conf) {
        this.keyType.initialize(conf);
        this.valueType.initialize(conf);
    }

    @Override
    public Pair<K, V> getDetachedValue(Pair<K, V> value) {
        return PTables.getDetachedValue(this, value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WritableTableType)) {
            return false;
        }
        WritableTableType that = (WritableTableType)obj;
        return this.keyType.equals(that.keyType) && this.valueType.equals(that.valueType);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append(this.keyType).append(this.valueType).toHashCode();
    }
}

