/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.writable;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;
import org.apache.crunch.Union;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.PTypeUtils;
import org.apache.crunch.types.writable.WritableGroupedTableType;
import org.apache.crunch.types.writable.WritableTableType;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.io.Writable;

public class WritableTypeFamily
implements PTypeFamily {
    private static final WritableTypeFamily INSTANCE = new WritableTypeFamily();

    public static WritableTypeFamily getInstance() {
        return INSTANCE;
    }

    private WritableTypeFamily() {
    }

    @Override
    public PType<Void> nulls() {
        return Writables.nulls();
    }

    @Override
    public PType<String> strings() {
        return Writables.strings();
    }

    @Override
    public PType<Long> longs() {
        return Writables.longs();
    }

    @Override
    public PType<Integer> ints() {
        return Writables.ints();
    }

    @Override
    public PType<Float> floats() {
        return Writables.floats();
    }

    @Override
    public PType<Double> doubles() {
        return Writables.doubles();
    }

    @Override
    public PType<Boolean> booleans() {
        return Writables.booleans();
    }

    @Override
    public PType<ByteBuffer> bytes() {
        return Writables.bytes();
    }

    @Override
    public <T> PType<T> records(Class<T> clazz) {
        return Writables.records(clazz);
    }

    public <W extends Writable> PType<W> writables(Class<W> clazz) {
        return Writables.writables(clazz);
    }

    @Override
    public <K, V> PTableType<K, V> tableOf(PType<K> key, PType<V> value) {
        return Writables.tableOf(key, value);
    }

    @Override
    public <V1, V2> PType<Pair<V1, V2>> pairs(PType<V1> p1, PType<V2> p2) {
        return Writables.pairs(p1, p2);
    }

    @Override
    public <V1, V2, V3> PType<Tuple3<V1, V2, V3>> triples(PType<V1> p1, PType<V2> p2, PType<V3> p3) {
        return Writables.triples(p1, p2, p3);
    }

    @Override
    public <V1, V2, V3, V4> PType<Tuple4<V1, V2, V3, V4>> quads(PType<V1> p1, PType<V2> p2, PType<V3> p3, PType<V4> p4) {
        return Writables.quads(p1, p2, p3, p4);
    }

    @Override
    public PType<TupleN> tuples(PType<?> ... ptypes) {
        return Writables.tuples(ptypes);
    }

    @Override
    public <T> PType<Collection<T>> collections(PType<T> ptype) {
        return Writables.collections(ptype);
    }

    @Override
    public <T> PType<Map<String, T>> maps(PType<T> ptype) {
        return Writables.maps(ptype);
    }

    @Override
    public <T> PType<T> as(PType<T> ptype) {
        if (ptype instanceof WritableType || ptype instanceof WritableTableType || ptype instanceof WritableGroupedTableType) {
            return ptype;
        }
        if (ptype instanceof PGroupedTableType) {
            PTableType ptt = ((PGroupedTableType)ptype).getTableType();
            return new WritableGroupedTableType((WritableTableType)this.as(ptt));
        }
        PType<T> prim = Writables.getPrimitiveType(ptype.getTypeClass());
        if (prim != null) {
            return prim;
        }
        return PTypeUtils.convert(ptype, this);
    }

    @Override
    public <T extends Tuple> PType<T> tuples(Class<T> clazz, PType<?> ... ptypes) {
        return Writables.tuples(clazz, (PType[])ptypes);
    }

    @Override
    public <S, T> PType<T> derived(Class<T> clazz, MapFn<S, T> inputFn, MapFn<T, S> outputFn, PType<S> base) {
        return Writables.derived(clazz, inputFn, outputFn, base);
    }

    @Override
    public <S, T> PType<T> derivedImmutable(Class<T> clazz, MapFn<S, T> inputFn, MapFn<T, S> outputFn, PType<S> base) {
        return Writables.derivedImmutable(clazz, inputFn, outputFn, base);
    }

    @Override
    public PType<Union> unionOf(PType<?> ... ptypes) {
        return Writables.unionOf(ptypes);
    }
}

