/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;

public class DoFnIterator<S, T>
implements Iterator<T> {
    private final Iterator<S> iter;
    private final DoFn<S, T> fn;
    private CacheEmitter<T> cache;
    private boolean cleanup;

    public DoFnIterator(Iterator<S> iter, DoFn<S, T> fn) {
        this.iter = iter;
        this.fn = fn;
        this.cache = new CacheEmitter();
        this.cleanup = false;
    }

    @Override
    public boolean hasNext() {
        while (this.cache.isEmpty() && this.iter.hasNext()) {
            this.fn.process(this.iter.next(), this.cache);
        }
        if (this.cache.isEmpty() && !this.cleanup) {
            this.fn.cleanup(this.cache);
            this.cleanup = true;
        }
        return !this.cache.isEmpty();
    }

    @Override
    public T next() {
        return this.cache.poll();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class CacheEmitter<T>
    implements Emitter<T> {
        private final LinkedList<T> cache = Lists.newLinkedList();

        private CacheEmitter() {
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public T poll() {
            return this.cache.poll();
        }

        @Override
        public void emit(T emitted) {
            this.cache.add(emitted);
        }

        @Override
        public void flush() {
        }
    }
}

