/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.util;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.TupleN;

public class Tuples {

    public static class TupleNIterable
    implements Iterable<TupleN> {
        private final Iterator<?>[] iters;

        public TupleNIterable(Iterable<?> ... iterables) {
            this.iters = new Iterator[iterables.length];
            for (int i = 0; i < this.iters.length; ++i) {
                this.iters[i] = iterables[i].iterator();
            }
        }

        @Override
        public Iterator<TupleN> iterator() {
            return new TuplifyIterator<TupleN>((Iterator[])this.iters){

                public TupleN next() {
                    Object[] values = new Object[TupleNIterable.this.iters.length];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.next(i);
                    }
                    return new TupleN(values);
                }
            };
        }
    }

    public static class QuadIterable<A, B, C, D>
    implements Iterable<Tuple4<A, B, C, D>> {
        private final Iterable<A> first;
        private final Iterable<B> second;
        private final Iterable<C> third;
        private final Iterable<D> fourth;

        public QuadIterable(Iterable<A> first, Iterable<B> second, Iterable<C> third, Iterable<D> fourth) {
            this.first = first;
            this.second = second;
            this.third = third;
            this.fourth = fourth;
        }

        @Override
        public Iterator<Tuple4<A, B, C, D>> iterator() {
            return new TuplifyIterator<Tuple4<A, B, C, D>>(new Iterator[]{this.first.iterator(), this.second.iterator(), this.third.iterator(), this.fourth.iterator()}){

                public Tuple4<A, B, C, D> next() {
                    return new Tuple4<Object, Object, Object, Object>(this.next(0), this.next(1), this.next(2), this.next(3));
                }
            };
        }
    }

    public static class TripIterable<A, B, C>
    implements Iterable<Tuple3<A, B, C>> {
        private final Iterable<A> first;
        private final Iterable<B> second;
        private final Iterable<C> third;

        public TripIterable(Iterable<A> first, Iterable<B> second, Iterable<C> third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        @Override
        public Iterator<Tuple3<A, B, C>> iterator() {
            return new TuplifyIterator<Tuple3<A, B, C>>(new Iterator[]{this.first.iterator(), this.second.iterator(), this.third.iterator()}){

                public Tuple3<A, B, C> next() {
                    return new Tuple3<Object, Object, Object>(this.next(0), this.next(1), this.next(2));
                }
            };
        }
    }

    public static class PairIterable<S, T>
    implements Iterable<Pair<S, T>> {
        private final Iterable<S> first;
        private final Iterable<T> second;

        public PairIterable(Iterable<S> first, Iterable<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Iterator<Pair<S, T>> iterator() {
            return new TuplifyIterator<Pair<S, T>>(new Iterator[]{this.first.iterator(), this.second.iterator()}){

                public Pair<S, T> next() {
                    return Pair.of(this.next(0), this.next(1));
                }
            };
        }
    }

    private static abstract class TuplifyIterator<T>
    extends UnmodifiableIterator<T> {
        protected List<Iterator<?>> iterators;

        public TuplifyIterator(Iterator<?> ... iterators) {
            this.iterators = Lists.newArrayList((Object[])iterators);
        }

        public boolean hasNext() {
            for (Iterator<?> iter : this.iterators) {
                if (iter.hasNext()) continue;
                return false;
            }
            return true;
        }

        protected Object next(int index) {
            return this.iterators.get(index).next();
        }
    }
}

