/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.Transaction;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.LoadFieldManager;
import org.datanucleus.store.fieldmanager.SingleTypeFieldManager;
import org.datanucleus.store.objectvaluegenerator.ObjectValueGenerator;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractStateManager
implements ObjectProvider {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final SingleTypeFieldManager HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
    protected static final int FLAG_STORING_PC = 65536;
    protected static final int FLAG_NEED_INHERITANCE_VALIDATION = 32768;
    protected static final int FLAG_POSTINSERT_UPDATE = 16384;
    protected static final int FLAG_LOADINGFPFIELDS = 8192;
    protected static final int FLAG_POSTLOAD_PENDING = 4096;
    protected static final int FLAG_CHANGING_STATE = 2048;
    protected static final int FLAG_FLUSHED_NEW = 1024;
    protected static final int FLAG_BECOMING_DELETED = 512;
    protected static final int FLAG_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 256;
    protected static final int FLAG_RETRIEVING_DETACHED_STATE = 128;
    protected static final int FLAG_RESETTING_DETACHED_STATE = 64;
    protected static final int FLAG_ATTACHING = 32;
    protected static final int FLAG_DETACHING = 16;
    protected static final int FLAG_MAKING_TRANSIENT = 8;
    protected static final int FLAG_FLUSHING = 4;
    protected static final int FLAG_DISCONNECTING = 2;
    protected int flags;
    protected boolean restoreValues = false;
    protected ExecutionContext myEC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected byte persistenceFlags;
    protected FetchPlanForClass myFP;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected Lock lock = null;
    protected short lockMode = 0;
    protected byte savedFlags;
    protected boolean[] savedLoadedFields = null;
    protected Map associatedValuesMap = null;
    protected ActivityState activity;
    protected FieldManager currFM = null;
    protected short objectType = 0;
    protected List<EmbeddedOwnerRelation> embeddedOwners = null;
    boolean[] preDeleteLoadedFields = null;
    public static final HashMap<String, ObjectValueGenerator> objectValGenerators = new HashMap(1);

    public AbstractStateManager(ExecutionContext ec, AbstractClassMetaData cmd) {
        this.connect(ec, cmd);
    }

    public void connect(ExecutionContext ec, AbstractClassMetaData cmd) {
        int fieldCount = cmd.getMemberCount();
        this.cmd = cmd;
        this.dirtyFields = new boolean[fieldCount];
        this.loadedFields = new boolean[fieldCount];
        this.dirty = false;
        this.myEC = ec;
        this.myFP = this.myEC.getFetchPlan().manageFetchPlanForClass(cmd);
        this.lock = new ReentrantLock();
        this.lockMode = 0;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
        this.objectType = 0;
        this.activity = ActivityState.NONE;
        this.myVersion = null;
        this.transactionalVersion = null;
        this.persistenceFlags = 0;
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public ExecutionContext getExecutionContext() {
        return this.myEC;
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.myEC.getCallbackHandler();
    }

    public abstract Object getObject();

    public String getObjectAsPrintable() {
        return StringUtils.toJVMIDString(this.getObject());
    }

    public String toString() {
        return "StateManager[pc=" + StringUtils.toJVMIDString(this.getObject()) + ", lifecycle=" + this.myLC + "]";
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = new IdentityReference(this);
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    public boolean isInserting() {
        return this.activity == ActivityState.INSERTING;
    }

    public boolean isWaitingToBeFlushedToDatastore() {
        return this.myLC.stateType() == 1 && !this.isFlushedNew();
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    public void setStoringPC() {
        this.flags |= 0x10000;
    }

    public void unsetStoringPC() {
        this.flags &= 0xFFFEFFFF;
    }

    protected boolean isStoringPC() {
        return (this.flags & 0x10000) != 0;
    }

    void setPostLoadPending(boolean flag) {
        this.flags = flag ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    protected boolean isPostLoadPending() {
        return (this.flags & 0x1000) != 0;
    }

    protected boolean isChangingState() {
        return (this.flags & 0x800) != 0;
    }

    void setResettingDetachedState(boolean flag) {
        this.flags = flag ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    protected boolean isResettingDetachedState() {
        return (this.flags & 0x40) != 0;
    }

    void setRetrievingDetachedState(boolean flag) {
        this.flags = flag ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    protected boolean isRetrievingDetachedState() {
        return (this.flags & 0x80) != 0;
    }

    void setDisconnecting(boolean flag) {
        this.flags = flag ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    protected boolean isDisconnecting() {
        return (this.flags & 2) != 0;
    }

    void setMakingTransient(boolean flag) {
        this.flags = flag ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    protected boolean isMakingTransient() {
        return (this.flags & 8) != 0;
    }

    public boolean isDeleting() {
        return this.activity == ActivityState.DELETING;
    }

    void setBecomingDeleted(boolean flag) {
        this.flags = flag ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean becomingDeleted() {
        return (this.flags & 0x200) > 0;
    }

    public void markForInheritanceValidation() {
        this.flags |= 0x8000;
    }

    void setDetaching(boolean flag) {
        this.flags = flag ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isDetaching() {
        return (this.flags & 0x10) != 0;
    }

    void setAttaching(boolean flag) {
        this.flags = flag ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean isAttaching() {
        return (this.flags & 0x20) != 0;
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(Object pc) {
        return this.transactionalVersion;
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    public void setFlushedNew(boolean flag) {
        this.flags = flag ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isFlushedNew() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isFlushedToDatastore() {
        return !this.dirty;
    }

    public void setFlushing(boolean flushing) {
        this.flags = flushing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected boolean isFlushing() {
        return (this.flags & 4) != 0;
    }

    public void markAsFlushed() {
        this.clearDirtyFlags();
    }

    protected void preStateChange() {
        this.flags |= 0x800;
    }

    protected abstract void postStateChange();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((ObjectProvider)this, fgOnly);
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionReadField(boolean isLoaded) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            if (this.myLC == null) {
                Object var5_2 = null;
                if (this.myEC.getMultithreaded()) {
                    this.lock.unlock();
                    this.myEC.getLock().unlock();
                }
                return;
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
                Object var3_5 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.postStateChange();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
            throw throwable;
        }
        Object var5_3 = null;
        if (this.myEC.getMultithreaded()) {
            this.lock.unlock();
            this.myEC.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionWriteField() {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
                Object var2_1 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.postStateChange();
                throw throwable;
            }
            Object var4_4 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.getCallbackHandler().preClear(this.getObject());
                this.getCallbackHandler().postClear(this.getObject());
                Object var2_1 = null;
                this.myLC = this.myLC.transitionEvict(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.myLC = this.myLC.transitionEvict(this);
                throw throwable;
            }
            Object var4_4 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.myVersion = this.transactionalVersion;
            }
            this.lockMode = 0;
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myEC.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.transactionalVersion = this.myVersion;
            }
            this.lockMode = 0;
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDeletePersistent() {
        if (this.isDeleting()) {
            throw new NucleusUserException(LOCALISER.msg("026008"));
        }
        this.activity = ActivityState.DELETING;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myEC.flushInternal(false);
            }
            if (!this.isEmbedded()) {
                this.myEC.getStoreManager().getPersistenceHandler().deleteObject(this);
            }
            this.preDeleteLoadedFields = null;
            Object var2_1 = null;
            this.activity = ActivityState.NONE;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.activity = ActivityState.NONE;
            throw throwable;
        }
    }

    public void locate() {
        this.myEC.getStoreManager().getPersistenceHandler().locateObject(this);
    }

    public abstract void provideFields(int[] var1, FieldManager var2);

    public abstract void replaceFields(int[] var1, FieldManager var2);

    protected boolean areFieldsLoaded(int[] fieldNumbers) {
        if (fieldNumbers == null) {
            return true;
        }
        for (int i = 0; i < fieldNumbers.length; ++i) {
            if (this.loadedFields[fieldNumbers[i]]) continue;
            return false;
        }
        return true;
    }

    public void unloadNonFetchPlanFields() {
        int[] fpFieldNumbers = this.myFP.getMemberNumbers();
        int[] nonfpFieldNumbers = null;
        if (fpFieldNumbers == null || fpFieldNumbers.length == 0) {
            nonfpFieldNumbers = this.cmd.getAllMemberPositions();
        } else {
            int fieldCount = this.cmd.getMemberCount();
            if (fieldCount == fpFieldNumbers.length) {
                return;
            }
            nonfpFieldNumbers = new int[fieldCount - fpFieldNumbers.length];
            int currentFPFieldIndex = 0;
            int j = 0;
            for (int i = 0; i < fieldCount; ++i) {
                if (currentFPFieldIndex >= fpFieldNumbers.length) {
                    nonfpFieldNumbers[j++] = i;
                    continue;
                }
                if (fpFieldNumbers[currentFPFieldIndex] == i) {
                    ++currentFPFieldIndex;
                    continue;
                }
                nonfpFieldNumbers[j++] = i;
            }
        }
        for (int i = 0; i < nonfpFieldNumbers.length; ++i) {
            this.loadedFields[nonfpFieldNumbers[i]] = false;
        }
    }

    protected void markPKFieldsAsLoaded() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                this.loadedFields[pkPositions[i]] = true;
            }
        }
    }

    protected void updateLevel2CacheForFields(int[] fieldNumbers) {
        int[] cacheFieldsToLoad;
        CachedPC cachedPC;
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && !this.myEC.isObjectModifiedInTransaction(this.myID) && (cachedPC = l2cache.get(this.myID)) != null && (cacheFieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, false)) != null && cacheFieldsToLoad.length > 0) {
            CachedPC copyCachedPC = cachedPC.getCopy();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("026033", (Object)StringUtils.toJVMIDString(this.getObject()), this.myID, (Object)StringUtils.intArrayToString(cacheFieldsToLoad)));
            }
            this.provideFields(cacheFieldsToLoad, new L2CachePopulateFieldManager(this, copyCachedPC));
            this.myEC.getNucleusContext().getLevel2Cache().put(this.getInternalObjectId(), copyCachedPC);
        }
    }

    protected int[] loadFieldsFromLevel2Cache(int[] fieldNumbers) {
        int[] cacheFieldsToLoad;
        CachedPC cachedPC;
        if (fieldNumbers == null || fieldNumbers.length == 0 || this.myEC.isFlushing() || this.myLC.isDeleted() || this.isDeleting() || this.getExecutionContext().getTransaction().isCommitting()) {
            return fieldNumbers;
        }
        if (!this.myEC.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.level2.loadFields", true)) {
            return fieldNumbers;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && (cachedPC = l2cache.get(this.myID)) != null && (cacheFieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, true)) != null && cacheFieldsToLoad.length > 0) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("026034", (Object)StringUtils.toJVMIDString(this.getObject()), this.myID, (Object)StringUtils.intArrayToString(cacheFieldsToLoad)));
            }
            this.replaceFields(cacheFieldsToLoad, new L2CacheRetrieveFieldManager(this, cachedPC));
        }
        return ClassUtils.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if ((this.flags & 0x2000) != 0) {
            return;
        }
        this.flags |= 0x2000;
        try {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state));
                this.updateLevel2CacheForFields(fieldNumbers);
            }
            Object var4_3 = null;
            this.flags &= 0xFFFFDFFF;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.flags &= 0xFFFFDFFF;
            throw throwable;
        }
    }

    public void loadFieldFromDatastore(int fieldNumber) {
        this.loadFieldsFromDatastore(new int[]{fieldNumber});
    }

    protected void loadFieldsFromDatastore(int[] fieldNumbers) {
        if (this.myLC.isNew() && this.myLC.isPersistent() && !this.isFlushedNew()) {
            return;
        }
        if ((this.flags & 0x8000) != 0) {
            String className = this.myEC.getStoreManager().getClassNameForObjectID(this.myID, this.myEC.getClassLoaderResolver(), this.myEC);
            if (!this.getObject().getClass().getName().equals(className)) {
                this.myEC.removeObjectFromLevel1Cache(this.myID);
                this.myEC.removeObjectFromLevel2Cache(this.myID);
                throw new NucleusObjectNotFoundException("Object with id " + this.myID + " was created without validating of type " + this.getObject().getClass().getName() + " but is actually of type " + className);
            }
            this.flags &= 0xFFFF7FFF;
        }
        this.myEC.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
    }

    protected int[] getFieldNumbersOfLoadedOrDirtyFields(boolean[] loadedFields, boolean[] dirtyFields) {
        int numFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numFields;
        }
        int[] fieldNumbers = new int[numFields];
        int n = 0;
        int[] allFieldNumbers = this.cmd.getAllMemberPositions();
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            fieldNumbers[n++] = allFieldNumbers[i];
        }
        return fieldNumbers;
    }

    public boolean[] getDirtyFields() {
        boolean[] copy = new boolean[this.dirtyFields.length];
        System.arraycopy(this.dirtyFields, 0, copy, 0, this.dirtyFields.length);
        return copy;
    }

    public int[] getDirtyFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.dirtyFields, true);
    }

    public boolean[] getLoadedFields() {
        return (boolean[])this.loadedFields.clone();
    }

    public int[] getLoadedFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.loadedFields, true);
    }

    public boolean getAllFieldsLoaded() {
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) continue;
            return false;
        }
        return true;
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = ClassUtils.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    public boolean isFieldLoaded(int fieldNumber) {
        return this.loadedFields[fieldNumber];
    }

    protected void clearFieldsByNumbers(int[] fieldNumbers) {
        this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = false;
            this.dirtyFields[fieldNumbers[i]] = false;
        }
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fieldNumbers) {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields, fieldNumbers);
    }

    public void unloadField(String fieldName) {
        if (this.objectType != 0) {
            throw new NucleusUserException("Cannot unload field/property of embedded object");
        }
        AbstractMemberMetaData mmd = this.getClassMetaData().getMetaDataForMember(fieldName);
        this.loadedFields[mmd.getAbsoluteFieldNumber()] = false;
    }

    public boolean isEmbedded() {
        return this.objectType > 0;
    }

    public void setPcObjectType(short objType) {
        this.objectType = objType;
    }

    public void lock(short lockMode) {
        this.lockMode = lockMode;
    }

    public void unlock() {
        this.lockMode = 0;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public void setAssociatedValue(Object key, Object value) {
        if (this.associatedValuesMap == null) {
            this.associatedValuesMap = new HashMap(1);
        }
        this.associatedValuesMap.put(key, value);
    }

    public Object getAssociatedValue(Object key) {
        if (this.associatedValuesMap == null) {
            return null;
        }
        return this.associatedValuesMap.get(key);
    }

    public void removeAssociatedValue(Object key) {
        if (this.associatedValuesMap != null) {
            this.associatedValuesMap.remove(key);
            if (this.associatedValuesMap.isEmpty()) {
                this.associatedValuesMap = null;
            }
        }
    }

    public boolean containsAssociatedValue(Object key) {
        return this.associatedValuesMap != null && this.associatedValuesMap.containsKey(key);
    }

    public void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList<EmbeddedOwnerRelation>(1);
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation((AbstractStateManager)ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator<EmbeddedOwnerRelation> iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
            if (this.embeddedOwners.isEmpty()) {
                this.embeddedOwners = null;
            }
        }
    }

    public ObjectProvider[] getEmbeddedOwners() {
        if (this.embeddedOwners == null) {
            return null;
        }
        ObjectProvider[] owners = new ObjectProvider[this.embeddedOwners.size()];
        for (int i = 0; i < owners.length; ++i) {
            EmbeddedOwnerRelation relation = this.embeddedOwners.get(i);
            owners[i] = relation.sm;
        }
        return owners;
    }

    protected static ObjectValueGenerator getObjectValueGenerator(ExecutionContext ec, String genName) {
        ObjectValueGenerator valGen;
        if (!objectValGenerators.isEmpty() && (valGen = objectValGenerators.get(genName)) != null) {
            return valGen;
        }
        try {
            valGen = (ObjectValueGenerator)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_objectvaluegenerator", new String[]{"name"}, new String[]{genName}, "class-name", null, null);
            objectValGenerators.put(genName, valGen);
            return valGen;
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.info("Exception thrown generating value using objectvaluegenerator " + genName, e);
            throw new NucleusException("Exception thrown generating value for object", e);
        }
    }

    protected static class EmbeddedOwnerRelation {
        protected AbstractStateManager sm;
        protected int fieldNumber;

        public EmbeddedOwnerRelation(AbstractStateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

