/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCOMap;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SortedMap
extends AbstractMap
implements java.util.SortedMap,
SCOMap,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;
    protected transient int fieldNumber;
    protected TreeMap delegate;

    public SortedMap(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Map m = (Map)o;
        if (m != null) {
            this.initialiseDelegate();
            this.delegate.putAll(m);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    protected void initialiseDelegate() {
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new TreeMap(comparator) : new TreeMap();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        this.makeDirty();
    }

    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        TreeMap detached = new TreeMap();
        SCOUtils.detachCopyForMap(this.ownerOP, this.entrySet(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Map m = (Map)value;
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(fmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(fmd);
        TreeMap attachedKeysValues = new TreeMap();
        SCOUtils.attachCopyForMap(this.ownerOP, m.entrySet(), attachedKeysValues, keysWithoutIdentity, valuesWithoutIdentity);
        SCOUtils.updateMapWithMapKeysValues(this.ownerOP.getExecutionContext().getApiAdapter(), this, attachedKeysValues);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object firstKey() {
        return this.delegate.firstKey();
    }

    public Object lastKey() {
        return this.delegate.lastKey();
    }

    public java.util.SortedMap headMap(Object toKey) {
        return this.delegate.headMap(toKey);
    }

    public java.util.SortedMap subMap(Object fromKey, Object toKey) {
        return this.delegate.subMap(fromKey, toKey);
    }

    public java.util.SortedMap tailMap(Object fromKey) {
        return this.delegate.headMap(fromKey);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public void clear() {
        AbstractMemberMetaData mmd;
        if (this.ownerOP != null && !this.delegate.isEmpty() && (SCOUtils.hasDependentKey(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName)) || SCOUtils.hasDependentValue(mmd))) {
            for (Map.Entry entry : this.delegate.entrySet()) {
                if (SCOUtils.hasDependentKey(mmd)) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(entry.getKey());
                }
                if (!SCOUtils.hasDependentValue(mmd)) continue;
                this.ownerOP.getExecutionContext().deleteObjectInternal(entry.getValue());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.delegate.put(key, value);
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    public void putAll(Map m) {
        this.delegate.putAll(m);
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public Object remove(Object key) {
        AbstractMemberMetaData mmd;
        Object value = this.delegate.remove(key);
        if (this.ownerOP != null && (SCOUtils.hasDependentKey(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName)) || SCOUtils.hasDependentValue(mmd))) {
            if (SCOUtils.hasDependentKey(mmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(key);
            }
            if (SCOUtils.hasDependentValue(mmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(value);
            }
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return value;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new TreeMap(this.delegate);
    }
}

