/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.rle;

import java.io.IOException;
import java.io.OutputStream;
import parquet.Log;
import parquet.Preconditions;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.bytes.CapacityByteArrayOutputStream;
import parquet.column.values.bitpacking.BytePacker;
import parquet.column.values.bitpacking.Packer;

public class RunLengthBitPackingHybridEncoder {
    private static final Log LOG = Log.getLog(RunLengthBitPackingHybridEncoder.class);
    private final BytePacker packer;
    private final CapacityByteArrayOutputStream baos;
    private final int bitWidth;
    private final byte[] packBuffer;
    private int previousValue;
    private final int[] bufferedValues;
    private int numBufferedValues;
    private int repeatCount;
    private int bitPackedGroupCount;
    private long bitPackedRunHeaderPointer;
    private boolean toBytesCalled;

    public RunLengthBitPackingHybridEncoder(int bitWidth, int initialCapacity) {
        if (Log.DEBUG) {
            LOG.debug((Object)String.format("Encoding: RunLengthBitPackingHybridEncoder with bithWidth: %d initialCapacity %d", bitWidth, initialCapacity));
        }
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        this.baos = new CapacityByteArrayOutputStream(initialCapacity);
        this.packBuffer = new byte[bitWidth];
        this.bufferedValues = new int[8];
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
        this.reset(false);
    }

    private void reset(boolean resetBaos) {
        if (resetBaos) {
            this.baos.reset();
        }
        this.previousValue = 0;
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        this.bitPackedGroupCount = 0;
        this.bitPackedRunHeaderPointer = -1L;
        this.toBytesCalled = false;
    }

    public void writeInt(int value) throws IOException {
        if (value == this.previousValue) {
            ++this.repeatCount;
            if (this.repeatCount >= 8) {
                return;
            }
        } else {
            if (this.repeatCount >= 8) {
                this.writeRleRun();
            }
            this.repeatCount = 1;
            this.previousValue = value;
        }
        this.bufferedValues[this.numBufferedValues] = value;
        ++this.numBufferedValues;
        if (this.numBufferedValues == 8) {
            this.writeOrAppendBitPackedRun();
        }
    }

    private void writeOrAppendBitPackedRun() throws IOException {
        if (this.bitPackedGroupCount >= 63) {
            this.endPreviousBitPackedRun();
        }
        if (this.bitPackedRunHeaderPointer == -1L) {
            this.baos.write(0);
            this.bitPackedRunHeaderPointer = this.baos.getCurrentIndex();
        }
        this.packer.pack8Values(this.bufferedValues, 0, this.packBuffer, 0);
        this.baos.write(this.packBuffer);
        this.numBufferedValues = 0;
        this.repeatCount = 0;
        ++this.bitPackedGroupCount;
    }

    private void endPreviousBitPackedRun() {
        if (this.bitPackedRunHeaderPointer == -1L) {
            return;
        }
        byte bitPackHeader = (byte)(this.bitPackedGroupCount << 1 | 1);
        this.baos.setByte(this.bitPackedRunHeaderPointer, bitPackHeader);
        this.bitPackedRunHeaderPointer = -1L;
        this.bitPackedGroupCount = 0;
    }

    private void writeRleRun() throws IOException {
        this.endPreviousBitPackedRun();
        BytesUtils.writeUnsignedVarInt((int)(this.repeatCount << 1), (OutputStream)this.baos);
        BytesUtils.writeIntLittleEndianPaddedOnBitWidth((OutputStream)this.baos, (int)this.previousValue, (int)this.bitWidth);
        this.repeatCount = 0;
        this.numBufferedValues = 0;
    }

    public BytesInput toBytes() throws IOException {
        Preconditions.checkArgument((!this.toBytesCalled ? 1 : 0) != 0, (String)"You cannot call toBytes() more than once without calling reset()");
        if (this.repeatCount >= 8) {
            this.writeRleRun();
        } else if (this.numBufferedValues > 0) {
            for (int i = this.numBufferedValues; i < 8; ++i) {
                this.bufferedValues[i] = 0;
            }
            this.writeOrAppendBitPackedRun();
            this.endPreviousBitPackedRun();
        } else {
            this.endPreviousBitPackedRun();
        }
        this.toBytesCalled = true;
        return BytesInput.from((CapacityByteArrayOutputStream)this.baos);
    }

    public void reset() {
        this.reset(true);
    }

    public long getBufferedSize() {
        return this.baos.size();
    }

    public long getAllocatedSize() {
        return this.baos.getCapacity();
    }
}

