/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.spi.AbstractMetadataProvider;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.hive.HiveUtils;
import org.kitesdk.data.spi.hive.MetaStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HiveAbstractMetadataProvider
extends AbstractMetadataProvider
implements PartitionListener {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAbstractMetadataProvider.class);
    protected final Configuration conf;
    private MetaStoreUtil metastore;

    HiveAbstractMetadataProvider(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        this.conf = conf;
    }

    protected MetaStoreUtil getMetaStoreUtil() {
        if (this.metastore == null) {
            this.metastore = new MetaStoreUtil(this.conf);
        }
        return this.metastore;
    }

    protected abstract URI expectedLocation(String var1, String var2);

    protected boolean isManaged(String namespace, String name) {
        String resolved = this.resolveNamespace(namespace, name);
        if (resolved != null) {
            return HiveAbstractMetadataProvider.isManaged(this.getMetaStoreUtil().getTable(resolved, name));
        }
        return false;
    }

    protected boolean isExternal(String namespace, String name) {
        String resolved = this.resolveNamespace(namespace, name);
        if (resolved != null) {
            return HiveAbstractMetadataProvider.isExternal(this.getMetaStoreUtil().getTable(resolved, name));
        }
        return false;
    }

    public DatasetDescriptor load(String namespace, String name) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        String resolved = this.resolveNamespace(namespace, name);
        if (resolved != null) {
            return HiveUtils.descriptorForTable(this.conf, this.getMetaStoreUtil().getTable(resolved, name));
        }
        throw new DatasetNotFoundException("Hive table not found: " + namespace + "." + name);
    }

    public DatasetDescriptor update(String namespace, String name, DatasetDescriptor descriptor) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        Compatibility.checkDescriptor((DatasetDescriptor)descriptor);
        String resolved = this.resolveNamespace(namespace, name);
        if (resolved != null) {
            Table table = this.getMetaStoreUtil().getTable(resolved, name);
            HiveUtils.updateTableSchema(table, descriptor);
            this.getMetaStoreUtil().alterTable(table);
            return descriptor;
        }
        throw new DatasetNotFoundException("Hive table not found: " + namespace + "." + name);
    }

    public boolean delete(String namespace, String name) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        String resolved = this.resolveNamespace(namespace, name);
        if (resolved != null) {
            this.getMetaStoreUtil().dropTable(resolved, name);
            return true;
        }
        return false;
    }

    public boolean exists(String namespace, String name) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        return this.resolveNamespace(namespace, name) != null;
    }

    public Collection<String> namespaces() {
        List<String> databases = this.getMetaStoreUtil().getAllDatabases();
        ArrayList databasesWithDatasets = Lists.newArrayList();
        for (String db : databases) {
            if (!this.isNamespace(db)) continue;
            databasesWithDatasets.add(db);
        }
        return databasesWithDatasets;
    }

    public Collection<String> datasets(String namespace) {
        List<String> tables = this.getMetaStoreUtil().getAllTables(namespace);
        ArrayList readableTables = Lists.newArrayList();
        for (String name : tables) {
            if (!this.isReadable(namespace, name)) continue;
            readableTables.add(name);
        }
        return readableTables;
    }

    private boolean isNamespace(String database) {
        List<String> tables = this.getMetaStoreUtil().getAllTables(database);
        for (String name : tables) {
            if (!this.isReadable(database, name)) continue;
            return true;
        }
        return false;
    }

    private boolean isReadable(String namespace, String name) {
        Table table = this.getMetaStoreUtil().getTable(namespace, name);
        if (HiveAbstractMetadataProvider.isManaged(table) || HiveAbstractMetadataProvider.isExternal(table)) {
            try {
                HiveUtils.descriptorForTable(this.conf, table);
                return true;
            }
            catch (DatasetException e) {
            }
            catch (IllegalStateException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        return false;
    }

    public void partitionAdded(String namespace, String name, String path) {
        this.getMetaStoreUtil().addPartition(namespace, name, path);
    }

    protected String resolveNamespace(String namespace, String name) {
        return this.resolveNamespace(namespace, name, null);
    }

    protected String resolveNamespace(String namespace, String name, @Nullable URI location) {
        if (this.getMetaStoreUtil().exists(namespace, name)) {
            return namespace;
        }
        try {
            DatasetDescriptor descriptor = HiveUtils.descriptorForTable(this.conf, this.getMetaStoreUtil().getTable("default", name));
            URI expectedLocation = location;
            if (location == null) {
                expectedLocation = this.expectedLocation(namespace, name);
            }
            if (expectedLocation == null || HiveAbstractMetadataProvider.pathsEquivalent(expectedLocation, descriptor.getLocation())) {
                return "default";
            }
        }
        catch (DatasetNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private static boolean pathsEquivalent(URI left, @Nullable URI right) {
        if (right == null) {
            return false;
        }
        String leftAuth = left.getAuthority();
        String rightAuth = right.getAuthority();
        if (leftAuth != null && rightAuth != null && !leftAuth.equals(rightAuth)) {
            return false;
        }
        return Objects.equal((Object)left.getScheme(), (Object)right.getScheme()) && Objects.equal((Object)left.getPath(), (Object)right.getPath());
    }

    @VisibleForTesting
    static boolean isManaged(Table table) {
        return TableType.MANAGED_TABLE.toString().equals(table.getTableType());
    }

    @VisibleForTesting
    static boolean isExternal(Table table) {
        return TableType.EXTERNAL_TABLE.toString().equals(table.getTableType());
    }
}

