/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.hive.HiveAbstractMetadataProvider;
import org.kitesdk.data.spi.hive.HiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveExternalMetadataProvider
extends HiveAbstractMetadataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HiveExternalMetadataProvider.class);
    private final Path rootDirectory;
    private final FileSystem rootFileSystem;

    public HiveExternalMetadataProvider(Configuration conf, Path rootDirectory) {
        super(conf);
        Preconditions.checkNotNull((Object)rootDirectory, (Object)"Root cannot be null");
        try {
            this.rootFileSystem = rootDirectory.getFileSystem(conf);
            this.rootDirectory = this.rootFileSystem.makeQualified(rootDirectory);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not get FileSystem for root path", ex);
        }
    }

    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        Compatibility.checkDescriptor((DatasetDescriptor)descriptor);
        String resolved = this.resolveNamespace(namespace, name, descriptor.getLocation());
        if (resolved != null) {
            if (resolved.equals(namespace)) {
                throw new DatasetExistsException("Metadata already exists for dataset: " + namespace + "." + name);
            }
            LOG.warn("Creating table {}.{} for {}: replaces default.{}", new Object[]{namespace, name, this.pathForDataset(namespace, name), name});
            Compatibility.checkUpdate((DatasetDescriptor)this.load(resolved, name), (DatasetDescriptor)descriptor);
        }
        LOG.info("Creating an external Hive table: {}.{}", (Object)namespace, (Object)name);
        DatasetDescriptor newDescriptor = descriptor;
        if (descriptor.getLocation() == null) {
            newDescriptor = new DatasetDescriptor.Builder(descriptor).location(this.pathForDataset(namespace, name)).build();
        }
        FileSystemUtil.ensureLocationExists((DatasetDescriptor)newDescriptor, (Configuration)this.conf);
        Table table = HiveUtils.tableForDescriptor(namespace, name, newDescriptor, true);
        this.getMetaStoreUtil().createTable(table);
        return newDescriptor;
    }

    @Override
    protected URI expectedLocation(String namespace, String name) {
        return this.pathForDataset(namespace, name).toUri();
    }

    private Path pathForDataset(String namespace, String name) {
        Preconditions.checkState((this.rootDirectory != null ? 1 : 0) != 0, (Object)"Dataset repository root directory can not be null");
        return this.rootFileSystem.makeQualified(HiveUtils.pathForDataset(this.rootDirectory, namespace, name));
    }
}

