/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.hive.HiveAbstractMetadataProvider;
import org.kitesdk.data.spi.hive.HiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveManagedMetadataProvider
extends HiveAbstractMetadataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HiveManagedMetadataProvider.class);

    public HiveManagedMetadataProvider(Configuration conf) {
        super(conf);
    }

    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Compatibility.checkDatasetName((String)namespace, (String)name);
        Compatibility.checkDescriptor((DatasetDescriptor)descriptor);
        URI location = descriptor.getLocation();
        String resolved = this.resolveNamespace(namespace, name, location);
        if (resolved != null) {
            if (resolved.equals(namespace)) {
                throw new DatasetExistsException("Metadata already exists for dataset: " + namespace + "." + name);
            }
            if (location != null) {
                DatasetDescriptor loaded = this.load(resolved, name);
                LOG.warn("Creating table managed table {}.{}: replaces default.{}", new Object[]{namespace, name, name});
                Compatibility.checkUpdate((DatasetDescriptor)loaded, (DatasetDescriptor)descriptor);
                location = loaded.getLocation();
            }
        }
        LOG.info("Creating a managed Hive table named: " + name);
        boolean isExternal = location != null;
        DatasetDescriptor toCreate = descriptor;
        if (isExternal) {
            toCreate = new DatasetDescriptor.Builder(descriptor).location(location).build();
        }
        Table table = HiveUtils.tableForDescriptor(namespace, name, toCreate, isExternal);
        this.getMetaStoreUtil().createTable(table);
        Table newTable = this.getMetaStoreUtil().getTable(namespace, name);
        DatasetDescriptor newDescriptor = new DatasetDescriptor.Builder(descriptor).location(newTable.getSd().getLocation()).build();
        if (isExternal) {
            FileSystemUtil.ensureLocationExists((DatasetDescriptor)newDescriptor, (Configuration)this.conf);
        }
        return newDescriptor;
    }

    @Override
    protected URI expectedLocation(String namespace, String name) {
        return null;
    }
}

