/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.UnknownFormatException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;

class HiveUtils {
    static final String HDFS_SCHEME = "hdfs";
    private static final String CUSTOM_PROPERTIES_PROPERTY_NAME = "kite.custom.property.names";
    private static final String PARTITION_EXPRESSION_PROPERTY_NAME = "kite.partition.expression";
    private static final String COMPRESSION_TYPE_PROPERTY_NAME = "kite.compression.type";
    private static final String OLD_CUSTOM_PROPERTIES_PROPERTY_NAME = "cdk.custom.property.names";
    private static final String OLD_PARTITION_EXPRESSION_PROPERTY_NAME = "cdk.partition.expression";
    private static final String AVRO_SCHEMA_URL_PROPERTY_NAME = "avro.schema.url";
    private static final String AVRO_SCHEMA_LITERAL_PROPERTY_NAME = "avro.schema.literal";
    private static final Splitter NAME_SPLITTER = Splitter.on((char)',');
    private static final Joiner NAME_JOINER = Joiner.on((char)',');
    private static final Map<Format, String> FORMAT_TO_SERDE = ImmutableMap.builder().put((Object)Formats.AVRO, (Object)"org.apache.hadoop.hive.serde2.avro.AvroSerDe").put((Object)Formats.PARQUET, (Object)HiveUtils.getHiveParquetSerde()).build();
    private static final Map<String, Format> SERDE_TO_FORMAT = ImmutableMap.builder().put((Object)"org.apache.hadoop.hive.serde2.avro.AvroSerDe", (Object)Formats.AVRO).put((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", (Object)Formats.PARQUET).put((Object)"parquet.hive.serde.ParquetHiveSerDe", (Object)Formats.PARQUET).build();
    private static final Map<Format, String> FORMAT_TO_INPUT_FORMAT = ImmutableMap.builder().put((Object)Formats.AVRO, (Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat").put((Object)Formats.PARQUET, (Object)HiveUtils.getHiveParquetInputFormat()).build();
    private static final Map<Format, String> FORMAT_TO_OUTPUT_FORMAT = ImmutableMap.builder().put((Object)Formats.AVRO, (Object)"org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat").put((Object)Formats.PARQUET, (Object)HiveUtils.getHiveParquetOutputFormat()).build();
    private static final Map<String, String> PROVIDED_TYPES = ImmutableMap.builder().put((Object)"tinyint", (Object)"int").put((Object)"smallint", (Object)"int").put((Object)"int", (Object)"int").put((Object)"bigint", (Object)"long").build();
    private static DynMethods.StaticMethod hiveTypeForName = new DynMethods.Builder("getPrimitiveTypeInfo").impl(TypeInfoFactory.class, new Class[]{String.class}).buildStatic();

    HiveUtils() {
    }

    static DatasetDescriptor descriptorForTable(Configuration conf, Table table) {
        String compressionType;
        String schemaLiteral;
        String schemaUrlString;
        DatasetDescriptor.Builder builder = new DatasetDescriptor.Builder();
        String serializationLib = table.getSd().getSerdeInfo().getSerializationLib();
        if (!SERDE_TO_FORMAT.containsKey(serializationLib)) {
            throw new UnknownFormatException("Unknown format for serde:" + serializationLib);
        }
        Format format = SERDE_TO_FORMAT.get(serializationLib);
        builder.format(format);
        Path dataLocation = new Path(table.getSd().getLocation());
        FileSystem fs = HiveUtils.fsForPath(conf, dataLocation);
        builder.location(fs.makeQualified(dataLocation));
        Map properties = table.getParameters();
        String namesProperty = HiveUtils.coalesce((String)properties.get(CUSTOM_PROPERTIES_PROPERTY_NAME), (String)properties.get(OLD_CUSTOM_PROPERTIES_PROPERTY_NAME));
        if (namesProperty != null) {
            for (String property : NAME_SPLITTER.split((CharSequence)namesProperty)) {
                builder.property(property, (String)properties.get(property));
            }
        }
        if (HiveUtils.isPartitioned(table)) {
            String partitionProperty = HiveUtils.coalesce((String)properties.get(PARTITION_EXPRESSION_PROPERTY_NAME), (String)properties.get(OLD_PARTITION_EXPRESSION_PROPERTY_NAME));
            if (partitionProperty != null) {
                builder.partitionStrategy(Accessor.getDefault().fromExpression(partitionProperty));
            } else {
                builder.partitionStrategy(HiveUtils.fromPartitionColumns(HiveUtils.getPartCols(table)));
            }
        }
        if ((schemaUrlString = (String)properties.get(AVRO_SCHEMA_URL_PROPERTY_NAME)) != null) {
            try {
                builder.schemaUri(URI.create(schemaUrlString));
            }
            catch (IOException e) {
                throw new DatasetIOException("Could not read schema", e);
            }
        }
        if ((schemaLiteral = (String)properties.get(AVRO_SCHEMA_LITERAL_PROPERTY_NAME)) != null) {
            builder.schemaLiteral(schemaLiteral);
        }
        if ((compressionType = (String)properties.get(COMPRESSION_TYPE_PROPERTY_NAME)) != null) {
            builder.compressionType(compressionType);
        }
        try {
            return builder.build();
        }
        catch (IllegalStateException ex) {
            throw new DatasetException("Cannot find schema: missing metadata");
        }
    }

    private static boolean isPartitioned(Table table) {
        return HiveUtils.getPartCols(table).size() != 0;
    }

    private static List<FieldSchema> getPartCols(Table table) {
        ArrayList partKeys = table.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList();
            table.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    private static <T> T coalesce(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    static Table tableForDescriptor(String namespace, String name, DatasetDescriptor descriptor, boolean external) {
        boolean useLiteral;
        Table table = HiveUtils.createEmptyTable(namespace, name);
        if (external) {
            table.setTableType(TableType.EXTERNAL_TABLE.toString());
            table.getParameters().put("EXTERNAL", "TRUE");
            table.getSd().setLocation(descriptor.getLocation().toString());
        } else {
            table.setTableType(TableType.MANAGED_TABLE.toString());
        }
        HiveUtils.addPropertiesForDescriptor(table, descriptor);
        Format format = descriptor.getFormat();
        if (!FORMAT_TO_SERDE.containsKey(format)) {
            throw new UnknownFormatException("No known serde for format:" + format.getName());
        }
        table.getSd().getSerdeInfo().setSerializationLib(FORMAT_TO_SERDE.get(format));
        table.getSd().setInputFormat(FORMAT_TO_INPUT_FORMAT.get(format));
        table.getSd().setOutputFormat(FORMAT_TO_OUTPUT_FORMAT.get(format));
        URL schemaURL = descriptor.getSchemaUrl();
        try {
            useLiteral = schemaURL == null || !HDFS_SCHEME.equals(schemaURL.toURI().getScheme());
        }
        catch (URISyntaxException ex) {
            useLiteral = true;
        }
        if (useLiteral) {
            table.getParameters().put(AVRO_SCHEMA_LITERAL_PROPERTY_NAME, descriptor.getSchema().toString());
        } else {
            table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, schemaURL.toExternalForm());
        }
        table.getParameters().put(COMPRESSION_TYPE_PROPERTY_NAME, descriptor.getCompressionType().getName());
        table.getSd().setCols(HiveUtils.convertSchema(descriptor.getSchema()));
        if (descriptor.isPartitioned()) {
            PartitionStrategy ps = descriptor.getPartitionStrategy();
            table.getParameters().put(PARTITION_EXPRESSION_PROPERTY_NAME, Accessor.getDefault().toExpression(ps));
            table.setPartitionKeys(HiveUtils.partitionColumns(ps, descriptor.getSchema()));
        }
        return table;
    }

    static Table createEmptyTable(String namespace, String name) {
        Table table = new Table();
        table.setDbName(namespace);
        table.setTableName(name);
        table.setPartitionKeys(new ArrayList());
        table.setParameters(new HashMap());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList());
        sd.setCols(new ArrayList());
        sd.setParameters(new HashMap());
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setParameters(new HashMap());
        SkewedInfo skewInfo = new SkewedInfo();
        skewInfo.setSkewedColNames(new ArrayList());
        skewInfo.setSkewedColValues(new ArrayList());
        skewInfo.setSkewedColValueLocationMaps(new HashMap());
        sd.setSkewedInfo(skewInfo);
        table.setSd(sd);
        return table;
    }

    public static void updateTableSchema(Table table, DatasetDescriptor descriptor) {
        if (table.getParameters().get(AVRO_SCHEMA_LITERAL_PROPERTY_NAME) != null) {
            table.getParameters().put(AVRO_SCHEMA_LITERAL_PROPERTY_NAME, descriptor.getSchema().toString());
        } else if (table.getParameters().get(AVRO_SCHEMA_URL_PROPERTY_NAME) != null) {
            if (descriptor.getSchemaUrl() == null) {
                throw new DatasetException("Cannot update avro.schema.url since descriptor schema URL is not set.");
            }
            table.getParameters().put(AVRO_SCHEMA_URL_PROPERTY_NAME, descriptor.getSchemaUrl().toExternalForm());
        } else {
            throw new DatasetException("Cannot update Avro schema since neither avro.schema.literal nor avro.schema.url is set.");
        }
        HiveUtils.addPropertiesForDescriptor(table, descriptor);
    }

    static FileSystem fsForPath(Configuration conf, Path path) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot access FileSystem for uri:" + path, ex);
        }
    }

    private static void addPropertiesForDescriptor(Table table, DatasetDescriptor descriptor) {
        if (!descriptor.listProperties().isEmpty()) {
            for (String property : descriptor.listProperties()) {
                table.getParameters().put(property, descriptor.getProperty(property));
            }
            table.getParameters().put(CUSTOM_PROPERTIES_PROPERTY_NAME, NAME_JOINER.join((Iterable)descriptor.listProperties()));
        }
    }

    static Path pathForDataset(Path root, String namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        return new Path(root, new Path(namespace, name.replace('.', '/')));
    }

    static List<FieldSchema> partitionColumns(PartitionStrategy strategy, Schema schema) {
        ArrayList columns = Lists.newArrayList();
        for (FieldPartitioner fp : strategy.getFieldPartitioners()) {
            columns.add(new FieldSchema(fp.getName(), HiveUtils.getHiveType(SchemaUtil.getPartitionType((FieldPartitioner)fp, (Schema)schema)), "Partition column derived from '" + fp.getSourceName() + "' column, " + "generated by Kite."));
        }
        return columns;
    }

    @VisibleForTesting
    static PartitionStrategy fromPartitionColumns(List<FieldSchema> fields) {
        PartitionStrategy.Builder builder = new PartitionStrategy.Builder();
        for (FieldSchema hiveSchema : fields) {
            TypeInfo type = (TypeInfo)hiveTypeForName.invoke(new Object[]{hiveSchema.getType()});
            builder.provided(hiveSchema.getName(), PROVIDED_TYPES.get(type.getTypeName()));
        }
        return builder.build();
    }

    private static String getHiveType(Class<?> type) {
        String typeName = PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveJava(type);
        if (typeName == null) {
            throw new DatasetException("Unsupported FieldPartitioner type: " + type);
        }
        return typeName;
    }

    static List<FieldSchema> convertSchema(Schema avroSchema) {
        ArrayList columns = Lists.newArrayList();
        if (Schema.Type.RECORD.equals((Object)avroSchema.getType())) {
            for (Schema.Field field : avroSchema.getFields()) {
                columns.add(new FieldSchema(field.name(), HiveUtils.convert(field.schema()).getTypeName(), field.doc()));
            }
        } else {
            columns.add(new FieldSchema("column", HiveUtils.convert(avroSchema).getTypeName(), avroSchema.getDoc()));
        }
        return columns;
    }

    public static TypeInfo convert(Schema schema) {
        return (TypeInfo)SchemaUtil.visit((Schema)schema, (SchemaUtil.SchemaVisitor)new Converter());
    }

    private static String getHiveParquetInputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetInputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private static String getHiveParquetOutputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetOutputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private static String getHiveParquetSerde() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
        String oldClass = "parquet.hive.serde.ParquetHiveSerDe";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    static /* synthetic */ DynMethods.StaticMethod access$000() {
        return hiveTypeForName;
    }

    static class Converter
    extends SchemaUtil.SchemaVisitor<TypeInfo> {
        static final ImmutableMap<Schema.Type, TypeInfo> TYPE_TO_TYPEINFO = ImmutableMap.builder().put((Object)Schema.Type.BOOLEAN, HiveUtils.access$000().invoke(new Object[]{"boolean"})).put((Object)Schema.Type.INT, HiveUtils.access$000().invoke(new Object[]{"int"})).put((Object)Schema.Type.LONG, HiveUtils.access$000().invoke(new Object[]{"bigint"})).put((Object)Schema.Type.FLOAT, HiveUtils.access$000().invoke(new Object[]{"float"})).put((Object)Schema.Type.DOUBLE, HiveUtils.access$000().invoke(new Object[]{"double"})).put((Object)Schema.Type.STRING, HiveUtils.access$000().invoke(new Object[]{"string"})).put((Object)Schema.Type.ENUM, HiveUtils.access$000().invoke(new Object[]{"string"})).put((Object)Schema.Type.BYTES, HiveUtils.access$000().invoke(new Object[]{"binary"})).put((Object)Schema.Type.FIXED, HiveUtils.access$000().invoke(new Object[]{"binary"})).build();

        Converter() {
        }

        public TypeInfo record(Schema record, List<String> names, List<TypeInfo> types) {
            return TypeInfoFactory.getStructTypeInfo(names, types);
        }

        public TypeInfo union(Schema union, List<TypeInfo> options) {
            boolean nullable = false;
            ArrayList nonNullTypes = Lists.newArrayList();
            for (TypeInfo type : options) {
                if (type != null) {
                    nonNullTypes.add(type);
                    continue;
                }
                nullable = true;
            }
            if (nonNullTypes.size() == 1) {
                return (TypeInfo)nonNullTypes.get(0);
            }
            return TypeInfoFactory.getUnionTypeInfo((List)nonNullTypes);
        }

        public TypeInfo array(Schema array, TypeInfo element) {
            return TypeInfoFactory.getListTypeInfo((TypeInfo)element);
        }

        public TypeInfo map(Schema map, TypeInfo value) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)((TypeInfo)TYPE_TO_TYPEINFO.get((Object)Schema.Type.STRING)), (TypeInfo)value);
        }

        public TypeInfo primitive(Schema primitive) {
            return (TypeInfo)TYPE_TO_TYPEINFO.get((Object)primitive.getType());
        }
    }
}

