/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Key;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.RandomAccessDataset;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.hbase.DaoView;
import org.kitesdk.data.hbase.HBaseViewKeyInputFormat;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.PartitionKey;

class DaoDataset<E>
extends AbstractDataset<E>
implements RandomAccessDataset<E>,
InputFormatAccessor<E> {
    private final String namespace;
    private final String name;
    private final Dao<E> dao;
    private final DatasetDescriptor descriptor;
    private final URI uri;
    private final DaoView<E> unbounded;

    public DaoDataset(String namespace, String name, Dao<E> dao, DatasetDescriptor descriptor, URI uri, Class<E> type) {
        super(type, descriptor.getSchema());
        Preconditions.checkArgument((IndexedRecord.class.isAssignableFrom(type) || type == Object.class ? 1 : 0) != 0, (Object)"HBase only supports the generic and specific data models. The entity type must implement IndexedRecord");
        this.namespace = namespace;
        this.name = name;
        this.dao = dao;
        this.descriptor = descriptor;
        this.uri = uri;
        this.unbounded = new DaoView<E>(this, type);
    }

    Dao<E> getDao() {
        return this.dao;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public URI getUri() {
        return this.uri;
    }

    public DatasetDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected RefinableView<E> asRefinableView() {
        return this.unbounded;
    }

    public boolean isEmpty() {
        return this.unbounded.isEmpty();
    }

    public DaoView<E> filter(Constraints c) {
        return this.unbounded.filter(c);
    }

    public E get(Key key) {
        return this.dao.get(DaoDataset.keyFor(this.getDescriptor().getPartitionStrategy(), key));
    }

    public boolean put(E entity) {
        return this.dao.put(entity);
    }

    public long increment(Key key, String fieldName, long amount) {
        return this.dao.increment(DaoDataset.keyFor(this.getDescriptor().getPartitionStrategy(), key), fieldName, amount);
    }

    public void delete(Key key) {
        this.dao.delete(DaoDataset.keyFor(this.getDescriptor().getPartitionStrategy(), key));
    }

    public boolean delete(E entity) {
        return this.dao.delete(entity);
    }

    @Deprecated
    static PartitionKey keyFor(PartitionStrategy strategy, Key key) {
        int size = strategy.getFieldPartitioners().size();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = key.get(i);
        }
        return new PartitionKey(values);
    }

    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new HBaseViewKeyInputFormat(this);
    }
}

