/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.impl.Constants;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.data.spi.AbstractMetadataProvider;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HBaseMetadataProvider
extends AbstractMetadataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMetadataProvider.class);
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String REPLICATION_ID_PROP = "hbase.replication.scope";
    private HBaseAdmin hbaseAdmin;
    private SchemaManager schemaManager;

    public HBaseMetadataProvider(HBaseAdmin hbaseAdmin, SchemaManager schemaManager) {
        this.hbaseAdmin = hbaseAdmin;
        this.schemaManager = schemaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Schema schema;
        block12: {
            Preconditions.checkArgument((boolean)DEFAULT_NAMESPACE.equals(namespace), (Object)"Non-default namespaces are not supported");
            Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
            Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
            Compatibility.checkAndWarn((String)namespace, (String)HBaseMetadataProvider.getTableName(name), (Schema)descriptor.getSchema());
            Preconditions.checkArgument((boolean)descriptor.isColumnMapped(), (String)"Cannot create dataset %s: missing column mapping", (Object[])new Object[]{name});
            try {
                String managedSchemaName = "managed_schemas";
                if (!this.hbaseAdmin.tableExists(managedSchemaName)) {
                    HTableDescriptor table = new HTableDescriptor(managedSchemaName);
                    table.addFamily(new HColumnDescriptor("meta"));
                    table.addFamily(new HColumnDescriptor("schema"));
                    table.addFamily(new HColumnDescriptor(Constants.SYS_COL_FAMILY));
                    this.hbaseAdmin.createTable(table);
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot open schema table", e);
            }
            schema = HBaseMetadataProvider.getEmbeddedSchema(descriptor);
            String entitySchemaString = schema.toString(true);
            AvroEntitySchema entitySchema = new AvroEntitySchema(schema, entitySchemaString, descriptor.getColumnMapping());
            String tableName = HBaseMetadataProvider.getTableName(name);
            String entityName = HBaseMetadataProvider.getEntityName(name);
            this.schemaManager.refreshManagedSchemaCache(tableName, entityName);
            this.schemaManager.createSchema(tableName, entityName, entitySchemaString, "org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser", "org.kitesdk.data.hbase.avro.AvroKeySerDe", "org.kitesdk.data.hbase.avro.AvroEntitySerDe");
            try {
                if (!this.hbaseAdmin.tableExists(tableName)) {
                    HTableDescriptor desc = new HTableDescriptor(tableName);
                    desc.addFamily(this.columnFamily(Constants.SYS_COL_FAMILY, descriptor));
                    desc.addFamily(this.columnFamily(Constants.OBSERVABLE_COL_FAMILY, descriptor));
                    for (String columnFamily : entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies()) {
                        desc.addFamily(this.columnFamily(columnFamily, descriptor));
                    }
                    this.hbaseAdmin.createTable(desc);
                    break block12;
                }
                Set familiesToAdd = entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies();
                familiesToAdd.add(new String(Constants.SYS_COL_FAMILY));
                familiesToAdd.add(new String(Constants.OBSERVABLE_COL_FAMILY));
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(tableName.getBytes());
                for (HColumnDescriptor columnDesc : desc.getColumnFamilies()) {
                    String familyName = columnDesc.getNameAsString();
                    if (!familiesToAdd.contains(familyName)) continue;
                    familiesToAdd.remove(familyName);
                }
                if (familiesToAdd.size() <= 0) break block12;
                this.hbaseAdmin.disableTable(tableName);
                try {
                    for (String family : familiesToAdd) {
                        this.hbaseAdmin.addColumn(tableName, this.columnFamily(family, descriptor));
                    }
                }
                finally {
                    this.hbaseAdmin.enableTable(tableName);
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot prepare table: " + name, e);
            }
        }
        return HBaseMetadataProvider.getDatasetDescriptor(schema, descriptor.getLocation());
    }

    public DatasetDescriptor update(String namespace, String name, DatasetDescriptor descriptor) {
        Preconditions.checkArgument((boolean)DEFAULT_NAMESPACE.equals(namespace), (Object)"Non-default namespaces are not supported");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        Compatibility.checkAndWarn((String)namespace, (String)HBaseMetadataProvider.getTableName(name), (Schema)descriptor.getSchema());
        Preconditions.checkArgument((boolean)descriptor.isColumnMapped(), (String)"Cannot update dataset %s: missing column mapping", (Object[])new Object[]{name});
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        this.schemaManager.refreshManagedSchemaCache(tableName, entityName);
        Schema newSchema = HBaseMetadataProvider.getEmbeddedSchema(descriptor);
        String schemaString = newSchema.toString(true);
        AvroEntitySchema entitySchema = new AvroEntitySchema(newSchema, schemaString, descriptor.getColumnMapping());
        if (!this.schemaManager.hasSchemaVersion(tableName, entityName, entitySchema)) {
            this.schemaManager.migrateSchema(tableName, entityName, schemaString);
        } else {
            LOG.info("Schema hasn't changed, not migrating: (" + name + ")");
        }
        return HBaseMetadataProvider.getDatasetDescriptor(newSchema, descriptor.getLocation());
    }

    public DatasetDescriptor load(String namespace, String name) {
        Preconditions.checkArgument((boolean)DEFAULT_NAMESPACE.equals(namespace), (Object)"Non-default namespaces are not supported");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        if (!this.exists(namespace, name)) {
            throw new DatasetNotFoundException("No such dataset: " + name);
        }
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        return new DatasetDescriptor.Builder().schemaLiteral(this.schemaManager.getEntitySchema(tableName, entityName).getRawSchema()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String namespace, String name) {
        DatasetDescriptor descriptor;
        Preconditions.checkArgument((boolean)DEFAULT_NAMESPACE.equals(namespace), (Object)"Non-default namespaces are not supported");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        try {
            descriptor = this.load(namespace, name);
        }
        catch (DatasetNotFoundException e) {
            return false;
        }
        Preconditions.checkState((boolean)descriptor.isColumnMapped(), (Object)"[BUG] Existing descriptor has no column mapping");
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        this.schemaManager.deleteSchema(tableName, entityName);
        for (String columnFamily : descriptor.getColumnMapping().getRequiredColumnFamilies()) {
            try {
                this.hbaseAdmin.disableTable(tableName);
                try {
                    this.hbaseAdmin.deleteColumn(tableName, columnFamily);
                }
                finally {
                    this.hbaseAdmin.enableTable(tableName);
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot delete " + name, e);
            }
        }
        return true;
    }

    public boolean exists(String namespace, String name) {
        Preconditions.checkArgument((boolean)DEFAULT_NAMESPACE.equals(namespace), (Object)"Non-default namespaces are not supported");
        Preconditions.checkNotNull((Object)name, (Object)"Dataset name cannot be null");
        String tableName = HBaseMetadataProvider.getTableName(name);
        String entityName = HBaseMetadataProvider.getEntityName(name);
        this.schemaManager.refreshManagedSchemaCache(tableName, entityName);
        return this.schemaManager.hasManagedSchema(tableName, entityName);
    }

    public Collection<String> namespaces() {
        return ImmutableList.of((Object)DEFAULT_NAMESPACE);
    }

    public Collection<String> datasets(String namespace) {
        ArrayList datasets = Lists.newArrayList();
        for (String table : this.schemaManager.getTableNames()) {
            for (String entity : this.schemaManager.getEntityNames(table)) {
                datasets.add(table + "." + entity);
            }
        }
        return datasets;
    }

    static String getTableName(String name) {
        if (name.contains(".")) {
            return name.substring(0, name.indexOf(46));
        }
        return name;
    }

    static String getEntityName(String name) {
        return name.substring(name.indexOf(46) + 1);
    }

    private static Schema getEmbeddedSchema(DatasetDescriptor descriptor) {
        Schema schema = descriptor.getSchema();
        if (descriptor.isColumnMapped()) {
            schema = ColumnMappingParser.embedColumnMapping((Schema)schema, (ColumnMapping)descriptor.getColumnMapping());
        }
        if (descriptor.isPartitioned()) {
            schema = PartitionStrategyParser.embedPartitionStrategy((Schema)schema, (PartitionStrategy)descriptor.getPartitionStrategy());
        }
        return schema;
    }

    private static DatasetDescriptor getDatasetDescriptor(Schema schema, URI location) {
        return new DatasetDescriptor.Builder().schema(schema).location(location).build();
    }

    private HColumnDescriptor columnFamily(byte[] family, DatasetDescriptor descriptor) {
        return this.configure(new HColumnDescriptor(family), descriptor);
    }

    private HColumnDescriptor columnFamily(String family, DatasetDescriptor descriptor) {
        return this.configure(new HColumnDescriptor(family), descriptor);
    }

    private HColumnDescriptor configure(HColumnDescriptor column, DatasetDescriptor descriptor) {
        if (descriptor.hasProperty(REPLICATION_ID_PROP)) {
            String value = descriptor.getProperty(REPLICATION_ID_PROP);
            try {
                column.setScope(Integer.valueOf(value).intValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid replication scope: " + value, e);
            }
        }
        return column;
    }
}

