/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.hbase.DaoDataset;
import org.kitesdk.data.hbase.DaoView;
import org.kitesdk.data.hbase.HBaseMetadataProvider;
import org.kitesdk.data.hbase.impl.BaseDao;
import org.kitesdk.data.hbase.impl.BaseEntityScanner;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.spi.AbstractKeyRecordReaderWrapper;
import org.kitesdk.data.spi.FilteredRecordReader;

class HBaseViewKeyInputFormat<E>
extends InputFormat<E, Void> {
    private DaoDataset<E> dataset;
    private DaoView<E> view;
    private EntityMapper<E> entityMapper;

    public HBaseViewKeyInputFormat(DaoDataset<E> dataset) {
        this.dataset = dataset;
        this.view = null;
        Dao<E> dao = dataset.getDao();
        if (!(dao instanceof BaseDao)) {
            throw new UnsupportedOperationException("Only BaseDao subclasses supported.");
        }
        this.entityMapper = ((BaseDao)dao).getEntityMapper();
    }

    public HBaseViewKeyInputFormat(DaoView<E> view) {
        this((DaoDataset)view.getDataset());
        this.view = view;
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        return this.getDelegate(conf).getSplits(jobContext);
    }

    public RecordReader<E, Void> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = (Configuration)Hadoop.TaskAttemptContext.getConfiguration.invoke((Object)taskAttemptContext, new Object[0]);
        TableInputFormat delegate = this.getDelegate(conf);
        HBaseRecordReaderWrapper<E> unfilteredRecordReader = new HBaseRecordReaderWrapper<E>((RecordReader<ImmutableBytesWritable, Result>)delegate.createRecordReader(inputSplit, taskAttemptContext), this.entityMapper);
        if (this.view != null) {
            return new FilteredRecordReader(unfilteredRecordReader, this.view.getConstraints(), this.view.getAccessor());
        }
        return unfilteredRecordReader;
    }

    private TableInputFormat getDelegate(Configuration conf) throws IOException {
        TableInputFormat delegate = new TableInputFormat();
        String tableName = HBaseMetadataProvider.getTableName(this.dataset.getName());
        conf.set("hbase.mapreduce.inputtable", tableName);
        if (this.view != null) {
            Job tempJob = new Job();
            Scan scan = ((BaseEntityScanner)this.view.newEntityScanner()).getScan();
            TableMapReduceUtil.initTableMapperJob((String)tableName, (Scan)scan, TableMapper.class, null, null, (Job)tempJob);
            Configuration tempConf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)tempJob, new Object[0]);
            conf.set("hbase.mapreduce.scan", tempConf.get("hbase.mapreduce.scan"));
        }
        delegate.setConf(conf);
        return delegate;
    }

    private static class HBaseRecordReaderWrapper<E>
    extends AbstractKeyRecordReaderWrapper<E, ImmutableBytesWritable, Result> {
        private final EntityMapper<E> entityMapper;

        public HBaseRecordReaderWrapper(RecordReader<ImmutableBytesWritable, Result> delegate, EntityMapper<E> entityMapper) {
            super(delegate);
            this.entityMapper = entityMapper;
        }

        public E getCurrentKey() throws IOException, InterruptedException {
            return this.entityMapper.mapToEntity((Result)this.delegate.getCurrentValue());
        }
    }
}

