/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import com.google.common.base.Objects;
import org.apache.avro.Schema;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.spi.SchemaValidationUtil;

public class AvroEntitySchema
extends EntitySchema {
    private final Schema schema;

    public AvroEntitySchema(Schema schema, String rawSchema, ColumnMapping columnMapping) {
        super(schema.getName(), rawSchema, columnMapping);
        this.schema = schema;
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvroEntitySchema other = (AvroEntitySchema)obj;
        if (this.schema == null) {
            if (other.schema != null) {
                return false;
            }
        } else {
            if (this.schema.getFields().size() != other.getAvroSchema().getFields().size()) {
                return false;
            }
            for (Schema.Field field : this.schema.getFields()) {
                Schema.Field entitySchemaField = (Schema.Field)other.getAvroSchema().getFields().get(field.pos());
                if (AvroEntitySchema.fieldsEqual(field, this.getColumnMappingDescriptor().getFieldMapping(field.name()), entitySchemaField, other.getColumnMappingDescriptor().getFieldMapping(entitySchemaField.name()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean compatible(EntitySchema entitySchema) {
        if (!AvroEntitySchema.mappingCompatible(this, entitySchema)) {
            return false;
        }
        AvroEntitySchema avroEntitySchema = (AvroEntitySchema)entitySchema;
        if (!SchemaValidationUtil.canRead((Schema)this.schema, (Schema)avroEntitySchema.getAvroSchema())) {
            return false;
        }
        return SchemaValidationUtil.canRead((Schema)avroEntitySchema.getAvroSchema(), (Schema)this.schema);
    }

    private static boolean mappingCompatible(EntitySchema oldSchema, EntitySchema newSchema) {
        for (FieldMapping oldFieldMapping : oldSchema.getColumnMappingDescriptor().getFieldMappings()) {
            FieldMapping newFieldMapping = newSchema.getColumnMappingDescriptor().getFieldMapping(oldFieldMapping.getFieldName());
            if (newFieldMapping == null || oldFieldMapping.equals((Object)newFieldMapping)) continue;
            return false;
        }
        return true;
    }

    private static boolean fieldsEqual(Schema.Field field1, FieldMapping field1Mapping, Schema.Field field2, FieldMapping field2Mapping) {
        if (!field1.name().equals(field2.name())) {
            return false;
        }
        if (!AvroUtils.avroSchemaTypesEqual(field1.schema(), field2.schema())) {
            return false;
        }
        if (!Objects.equal((Object)field1Mapping, (Object)field2Mapping)) {
            return false;
        }
        if (field1.defaultValue() != null && field2.defaultValue() == null || field1.defaultValue() == null && field2.defaultValue() != null) {
            return false;
        }
        return field1.defaultValue() == null || field2.defaultValue() == null || field1.defaultValue().equals((Object)field2.defaultValue());
    }
}

