/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecord;
import org.codehaus.jackson.JsonNode;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.SerializationException;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroKeySchema;

public class AvroUtils {
    public static <T> T readAvroEntity(byte[] bytes, DatumReader<T> reader) {
        BinaryDecoder decoder = new DecoderFactory().binaryDecoder(bytes, null);
        return AvroUtils.readAvroEntity((Decoder)decoder, reader);
    }

    public static <T> T readAvroEntity(Decoder decoder, DatumReader<T> reader) {
        try {
            return (T)reader.read(null, decoder);
        }
        catch (IOException e) {
            throw new SerializationException("Could not deserialize Avro entity", (Throwable)e);
        }
    }

    public static <T> byte[] writeAvroEntity(T entity, DatumWriter<T> writer) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = new EncoderFactory().binaryEncoder((OutputStream)outputStream, null);
        AvroUtils.writeAvroEntity(entity, (Encoder)encoder, writer);
        return outputStream.toByteArray();
    }

    public static <T> void writeAvroEntity(T entity, Encoder encoder, DatumWriter<T> writer) {
        try {
            writer.write(entity, encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not serialize Avro entity", (Throwable)e);
        }
    }

    public static Schema.Field cloneField(Schema.Field field) {
        return new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue());
    }

    public static String inputStreamToString(InputStream in) {
        BufferedReader bufferedReader;
        int BUFFER_SIZE = 1024;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatasetException("Platform doesn't support UTF-8. It must!", (Throwable)e);
        }
        char[] buffer = new char[1024];
        StringBuilder stringBuilder = new StringBuilder(1024);
        int bytesRead = 0;
        try {
            while ((bytesRead = bufferedReader.read(buffer, 0, 1024)) > 0) {
                stringBuilder.append(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new DatasetException("Error reading from input stream", (Throwable)e);
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> getDefaultValueMap(Schema avroRecordSchema) {
        ArrayList<Schema.Field> defaultFields = new ArrayList<Schema.Field>();
        for (Schema.Field f : avroRecordSchema.getFields()) {
            if (f.defaultValue() == null) continue;
            defaultFields.add(new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultValue(), f.order()));
        }
        Schema defaultSchema = Schema.createRecord(defaultFields);
        Schema emptyRecordSchema = Schema.createRecord(new ArrayList());
        GenericDatumWriter writer = new GenericDatumWriter(emptyRecordSchema);
        GenericDatumReader reader = new GenericDatumReader(emptyRecordSchema, defaultSchema);
        GenericData.Record emptyRecord = new GenericData.Record(emptyRecordSchema);
        GenericRecord defaultRecord = (GenericRecord)AvroUtils.readAvroEntity(AvroUtils.writeAvroEntity(emptyRecord, writer), reader);
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        for (Schema.Field f : defaultFields) {
            defaultValueMap.put(f.name(), defaultRecord.get(f.name()));
        }
        return defaultValueMap;
    }

    public static AvroKeySchema mergeSpecificStringTypes(Class<? extends SpecificRecord> specificClass, AvroKeySchema keySchema) {
        Schema schemaField;
        try {
            schemaField = (Schema)specificClass.getField("SCHEMA$").get(null);
        }
        catch (IllegalArgumentException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new DatasetException((Throwable)e);
        }
        ArrayList fields = Lists.newArrayList();
        PartitionStrategy strategy = keySchema.getPartitionStrategy();
        for (Schema.Field field : keySchema.getAvroSchema().getFields()) {
            String sourceName = strategy.getPartitioner(field.name()).getSourceName();
            fields.add(AvroUtils.copy(schemaField.getField(sourceName)));
        }
        Schema schema = Schema.createRecord((String)keySchema.getAvroSchema().getName(), (String)keySchema.getAvroSchema().getDoc(), (String)keySchema.getAvroSchema().getNamespace(), (boolean)keySchema.getAvroSchema().isError());
        schema.setFields((List)fields);
        return new AvroKeySchema(schema, keySchema.getPartitionStrategy());
    }

    private static Schema.Field copy(Schema.Field f) {
        Schema.Field copy = AvroUtils.cloneField(f);
        for (Map.Entry prop : f.getJsonProps().entrySet()) {
            copy.addProp((String)prop.getKey(), (JsonNode)prop.getValue());
        }
        return copy;
    }

    public static AvroEntitySchema mergeSpecificStringTypes(Class<? extends SpecificRecord> specificClass, AvroEntitySchema entitySchema) {
        Schema schemaField;
        try {
            schemaField = (Schema)specificClass.getField("SCHEMA$").get(null);
        }
        catch (IllegalArgumentException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new DatasetException((Throwable)e);
        }
        return new AvroEntitySchema(schemaField, entitySchema.getRawSchema(), entitySchema.getColumnMappingDescriptor());
    }

    public static boolean avroSchemaTypesEqual(Schema schema1, Schema schema2) {
        if (schema1.getType() != schema2.getType()) {
            return false;
        }
        if (schema1.getType() == Schema.Type.ENUM || schema1.getType() == Schema.Type.FIXED) {
            return schema1.equals((Object)schema2);
        }
        if (schema1.getType() == Schema.Type.ARRAY) {
            return AvroUtils.avroSchemaTypesEqual(schema1.getElementType(), schema2.getElementType());
        }
        if (schema1.getType() == Schema.Type.MAP) {
            return AvroUtils.avroSchemaTypesEqual(schema1.getValueType(), schema2.getValueType());
        }
        if (schema1.getType() == Schema.Type.UNION) {
            if (schema1.getTypes().size() != schema2.getTypes().size()) {
                return false;
            }
            for (int i = 0; i < schema1.getTypes().size(); ++i) {
                if (AvroUtils.avroSchemaTypesEqual((Schema)schema1.getTypes().get(i), (Schema)schema2.getTypes().get(i))) continue;
                return false;
            }
            return true;
        }
        if (schema1.getType() == Schema.Type.RECORD) {
            if (schema1.getFields().size() != schema2.getFields().size()) {
                return false;
            }
            for (Schema.Field field1 : schema1.getFields()) {
                Schema.Field field2 = schema2.getField(field1.name());
                if (field2 == null) {
                    return false;
                }
                if (AvroUtils.avroSchemaTypesEqual(field1.schema(), field2.schema())) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

