/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.impl.EntityScannerBuilder;
import org.kitesdk.data.hbase.impl.HBaseUtils;
import org.kitesdk.data.hbase.impl.ScanModifier;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.ReaderWriterState;

public class BaseEntityScanner<E>
extends AbstractDatasetReader<E>
implements EntityScanner<E> {
    private final EntityMapper<E> entityMapper;
    private final HTablePool tablePool;
    private final String tableName;
    private Scan scan;
    private ResultScanner resultScanner;
    private Iterator<Result> iterator;
    private ReaderWriterState state;

    public BaseEntityScanner(Scan scan, HTablePool tablePool, String tableName, EntityMapper<E> entityMapper) {
        this.scan = scan;
        this.entityMapper = entityMapper;
        this.tablePool = tablePool;
        this.tableName = tableName;
        this.state = ReaderWriterState.NEW;
    }

    private BaseEntityScanner(Builder<E> scanBuilder) {
        byte[] keyBytes;
        this.entityMapper = scanBuilder.getEntityMapper();
        this.tablePool = scanBuilder.getTablePool();
        this.tableName = scanBuilder.getTableName();
        this.scan = new Scan();
        if (scanBuilder.getStartKey() != null) {
            keyBytes = this.entityMapper.getKeySerDe().serialize(scanBuilder.getStartKey());
            if (!scanBuilder.getStartInclusive()) {
                keyBytes = this.addZeroByte(keyBytes);
            }
            this.scan.setStartRow(keyBytes);
        }
        if (scanBuilder.getStopKey() != null) {
            keyBytes = this.entityMapper.getKeySerDe().serialize(scanBuilder.getStopKey());
            if (scanBuilder.getStopInclusive()) {
                keyBytes = this.addZeroByte(keyBytes);
            }
            this.scan.setStopRow(keyBytes);
        }
        if (scanBuilder.getCaching() != 0) {
            this.scan.setCaching(scanBuilder.getCaching());
        }
        if (scanBuilder.getEntityMapper() != null) {
            HBaseUtils.addColumnsToScan(this.entityMapper.getRequiredColumns(), this.scan);
        }
        if (scanBuilder.getFilterList().size() > 0) {
            FilterList filterList;
            if (scanBuilder.getPassAllFilters()) {
                filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, scanBuilder.getFilterList());
                this.scan.setFilter((Filter)filterList);
            } else {
                filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, scanBuilder.getFilterList());
                this.scan.setFilter((Filter)filterList);
            }
        }
        for (ScanModifier scanModifier : scanBuilder.getScanModifiers()) {
            this.scan = scanModifier.modifyScan(this.scan);
        }
        this.state = ReaderWriterState.NEW;
    }

    public Iterator<E> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.NEW), (String)"A scanner may not be opened more than once - current state:%s", (Object[])new Object[]{this.state});
        HTableInterface table = null;
        try {
            table = this.tablePool.getTable(this.tableName);
            try {
                this.resultScanner = table.getScanner(this.scan);
            }
            catch (IOException e) {
                throw new DatasetIOException("Failed to fetch scanner", e);
            }
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    throw new DatasetIOException("Error putting table back into pool", e);
                }
            }
        }
        this.iterator = this.resultScanner.iterator();
        this.state = ReaderWriterState.OPEN;
    }

    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        this.resultScanner.close();
        this.state = ReaderWriterState.CLOSED;
    }

    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    public boolean hasNext() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a scanner in state:%s", (Object[])new Object[]{this.state});
        return this.iterator.hasNext();
    }

    public E read() {
        throw new UnsupportedOperationException("read() not supported, use next().");
    }

    public E next() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a scanner in state:%s", (Object[])new Object[]{this.state});
        Result result = this.iterator.next();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return this.entityMapper.mapToEntity(result);
    }

    public void remove() {
        Preconditions.checkState((boolean)this.state.equals((Object)ReaderWriterState.OPEN), (String)"Attempt to read from a scanner in state:%s", (Object[])new Object[]{this.state});
        this.iterator.remove();
    }

    public Scan getScan() {
        return this.scan;
    }

    private byte[] addZeroByte(byte[] inBytes) {
        byte[] outBytes = new byte[inBytes.length + 1];
        System.arraycopy(inBytes, 0, outBytes, 0, inBytes.length);
        outBytes[inBytes.length] = 0;
        return outBytes;
    }

    public static class Builder<E>
    extends EntityScannerBuilder<E> {
        public Builder(HTablePool tablePool, String tableName, EntityMapper<E> entityMapper) {
            super(tablePool, tableName, entityMapper);
        }

        @Override
        public BaseEntityScanner<E> build() {
            return new BaseEntityScanner(this);
        }
    }
}

