/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;

public class KeySchema {
    private final String rawSchema;
    private final PartitionStrategy partitionStrategy;
    private final Map<String, Integer> fieldPositions;

    public KeySchema(String rawSchema, PartitionStrategy partitionStrategy) {
        this.rawSchema = rawSchema;
        this.partitionStrategy = partitionStrategy;
        this.fieldPositions = Maps.newHashMap();
        List partitioners = partitionStrategy.getFieldPartitioners();
        for (int i = 0; i < partitioners.size(); ++i) {
            FieldPartitioner fp = (FieldPartitioner)partitioners.get(i);
            if (!(fp instanceof IdentityFieldPartitioner)) continue;
            this.fieldPositions.put(fp.getSourceName(), i);
        }
    }

    public boolean compatible(KeySchema keySchema) {
        throw new UnsupportedOperationException("KeySchema class can't determine if two key schemas are compatible.");
    }

    public String getRawSchema() {
        return this.rawSchema;
    }

    public PartitionStrategy getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public int position(String fieldName) {
        if (this.fieldPositions.containsKey(fieldName)) {
            return this.fieldPositions.get(fieldName);
        }
        throw new DatasetException("Cannot recover " + fieldName + " from key");
    }
}

