/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.kitesdk.data.hbase.HBaseDatasetRepository;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;

public class Loader
implements Loadable {
    public void load() {
        Registration.register((URIPattern)new URIPattern("hbase::zk"), (URIPattern)new URIPattern("hbase::zk/:dataset?namespace=default"), (OptionBuilder)new OptionBuilder<DatasetRepository>(){

            public DatasetRepository getFromOptions(Map<String, String> options) {
                Configuration conf = HBaseConfiguration.create((Configuration)DefaultConfiguration.get());
                String[] hostsAndPort = Loader.parseHostsAndPort(options.get("zk"));
                conf.set("hbase.zookeeper.quorum", hostsAndPort[0]);
                String port = hostsAndPort[1];
                if (port != null) {
                    conf.set("hbase.zookeeper.property.clientPort", port);
                }
                return new HBaseDatasetRepository.Builder().configuration(conf).build();
            }
        });
    }

    @VisibleForTesting
    public static String[] parseHostsAndPort(String zkQuorum) {
        ArrayList hosts = Lists.newArrayList();
        String port = null;
        for (String hostPort : Splitter.on((char)',').split((CharSequence)zkQuorum)) {
            Iterator split = Splitter.on((char)':').split((CharSequence)hostPort).iterator();
            hosts.add(split.next());
            if (!split.hasNext()) continue;
            String p = (String)split.next();
            if (port == null) {
                port = p;
                continue;
            }
            if (port.equals(p)) continue;
            throw new IllegalArgumentException("Mismatched ports in " + zkQuorum);
        }
        return new String[]{Joiner.on((char)',').join((Iterable)hosts), port};
    }
}

