/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroKeySchema;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.impl.Constants;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTool {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaTool.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final AvroKeyEntitySchemaParser parser = new AvroKeyEntitySchemaParser();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JsonFactory factory = mapper.getJsonFactory();
    private final SchemaManager schemaManager;
    private final HBaseAdmin hbaseAdmin;

    public SchemaTool(HBaseAdmin hbaseAdmin, SchemaManager entityManager) {
        this.hbaseAdmin = hbaseAdmin;
        this.schemaManager = entityManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createOrMigrateSchemaDirectory(String schemaDirectory, boolean createTableAndFamilies) {
        List<String> schemaStrings;
        block14: {
            if (schemaDirectory.startsWith(CLASSPATH_PREFIX)) {
                URL dirURL = this.getClass().getClassLoader().getResource(schemaDirectory.substring(CLASSPATH_PREFIX.length()));
                if (dirURL != null && dirURL.getProtocol().equals("file")) {
                    try {
                        schemaStrings = this.getSchemaStringsFromDir(new File(dirURL.toURI()));
                    }
                    catch (URISyntaxException e) {
                        throw new DatasetException((Throwable)e);
                    }
                }
                if (dirURL != null && dirURL.getProtocol().equals("jar")) {
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    schemaStrings = this.getSchemaStringsFromJar(jarPath, schemaDirectory.substring(CLASSPATH_PREFIX.length()));
                    break block14;
                } else {
                    String msg = "Could not find classpath resource: " + schemaDirectory;
                    LOG.error(msg);
                    throw new DatasetException(msg);
                }
            }
            schemaStrings = this.getSchemaStringsFromDir(new File(schemaDirectory));
        }
        HashMap tableEntitySchemaMap = new HashMap();
        Iterator<Object> i$ = schemaStrings.iterator();
        block2: while (true) {
            if (!i$.hasNext()) {
                i$ = tableEntitySchemaMap.entrySet().iterator();
                break;
            }
            String string = i$.next();
            List<String> tables = this.getTablesFromSchemaString(string);
            Iterator<String> i$2 = tables.iterator();
            while (true) {
                if (!i$2.hasNext()) continue block2;
                String table = i$2.next();
                if (tableEntitySchemaMap.containsKey(table)) {
                    ((List)tableEntitySchemaMap.get(table)).add(string);
                    continue;
                }
                ArrayList<String> entityList = new ArrayList<String>();
                entityList.add(string);
                tableEntitySchemaMap.put(table, entityList);
            }
            break;
        }
        block4: while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            String table = (String)entry.getKey();
            List entitySchemas = (List)entry.getValue();
            if (entitySchemas.size() == 0) {
                String msg = "Table requested, but no entity schemas for Table: " + table;
                LOG.error(msg);
                throw new ValidationException(msg);
            }
            Iterator i$3 = ((List)entry.getValue()).iterator();
            while (true) {
                if (!i$3.hasNext()) continue block4;
                String entitySchema = (String)i$3.next();
                this.createOrMigrateSchema(table, entitySchema, createTableAndFamilies);
            }
            break;
        }
        return;
    }

    public void createOrMigrateSchemaFile(String tableName, String entitySchemaFilePath, boolean createTableAndFamilies) {
        this.createOrMigrateSchemaFile(tableName, new File(entitySchemaFilePath), createTableAndFamilies);
    }

    public void createOrMigrateSchemaFile(String tableName, File entitySchemaFile, boolean createTableAndFamilies) {
        this.createOrMigrateSchema(tableName, this.getSchemaStringFromFile(entitySchemaFile), createTableAndFamilies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrMigrateSchema(String tableName, String entitySchemaString, boolean createTableAndFamilies) {
        block15: {
            String entityName = this.getEntityNameFromSchemaString(entitySchemaString);
            AvroEntitySchema entitySchema = parser.parseEntitySchema(entitySchemaString);
            AvroKeySchema keySchema = parser.parseKeySchema(entitySchemaString);
            if (this.schemaManager.hasManagedSchema(tableName, entityName)) {
                KeySchema currentKeySchema = this.schemaManager.getKeySchema(tableName, entityName);
                if (!keySchema.equals(currentKeySchema)) {
                    String msg = "Migrating schema with different keys. Current: " + currentKeySchema.getRawSchema() + " New: " + keySchema.getRawSchema();
                    LOG.error(msg);
                    throw new ValidationException(msg);
                }
                if (!this.schemaManager.hasSchemaVersion(tableName, entityName, entitySchema)) {
                    LOG.info("Migrating Schema: (" + tableName + ", " + entityName + ")");
                    this.schemaManager.migrateSchema(tableName, entityName, entitySchemaString);
                } else {
                    LOG.info("Schema hasn't changed, not migrating: (" + tableName + ", " + entityName + ")");
                }
            } else {
                LOG.info("Creating Schema: (" + tableName + ", " + entityName + ")");
                parser.parseEntitySchema(entitySchemaString).getColumnMappingDescriptor().getRequiredColumnFamilies();
                this.schemaManager.createSchema(tableName, entityName, entitySchemaString, "org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser", "org.kitesdk.data.hbase.avro.AvroKeySerDe", "org.kitesdk.data.hbase.avro.AvroEntitySerDe");
            }
            if (createTableAndFamilies) {
                try {
                    if (!this.hbaseAdmin.tableExists(tableName)) {
                        HTableDescriptor desc = new HTableDescriptor(tableName);
                        desc.addFamily(new HColumnDescriptor(Constants.SYS_COL_FAMILY));
                        desc.addFamily(new HColumnDescriptor(Constants.OBSERVABLE_COL_FAMILY));
                        for (String columnFamily : entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies()) {
                            desc.addFamily(new HColumnDescriptor(columnFamily));
                        }
                        this.hbaseAdmin.createTable(desc);
                        break block15;
                    }
                    Set familiesToAdd = entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies();
                    familiesToAdd.add(new String(Constants.SYS_COL_FAMILY));
                    familiesToAdd.add(new String(Constants.OBSERVABLE_COL_FAMILY));
                    HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(tableName.getBytes());
                    for (HColumnDescriptor columnDesc : desc.getColumnFamilies()) {
                        String familyName = columnDesc.getNameAsString();
                        if (!familiesToAdd.contains(familyName)) continue;
                        familiesToAdd.remove(familyName);
                    }
                    if (familiesToAdd.size() <= 0) break block15;
                    this.hbaseAdmin.disableTable(tableName);
                    try {
                        for (String family : familiesToAdd) {
                            this.hbaseAdmin.addColumn(tableName, new HColumnDescriptor(family));
                        }
                    }
                    finally {
                        this.hbaseAdmin.enableTable(tableName);
                    }
                }
                catch (IOException e) {
                    throw new DatasetException((Throwable)e);
                }
            }
        }
    }

    private String getSchemaStringFromFile(File schemaFile) {
        String schemaString;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(schemaFile);
            schemaString = AvroUtils.inputStreamToString(fis);
        }
        catch (IOException e) {
            throw new DatasetException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return schemaString;
    }

    private List<String> getTablesFromSchemaString(String schema) {
        try {
            JsonParser jp = factory.createJsonParser(schema);
            JsonNode node = mapper.readTree(jp);
            if (node.get("tables") == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> result = new ArrayList<String>(node.get("tables").size());
            Iterator it = node.get("tables").getElements();
            while (it.hasNext()) {
                result.add(((JsonNode)it.next()).getTextValue());
            }
            return result;
        }
        catch (JsonParseException e) {
            throw new ValidationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    private String getEntityNameFromSchemaString(String schema) {
        try {
            JsonParser jp = factory.createJsonParser(schema);
            JsonNode node = mapper.readTree(jp);
            if (node.get("name") == null) {
                return null;
            }
            return node.get("name").getTextValue();
        }
        catch (JsonParseException e) {
            throw new ValidationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    private List<String> getSchemaStringsFromDir(File dir) {
        ArrayList<String> schemaStrings = new ArrayList<String>();
        Collection schemaFiles = FileUtils.listFiles((File)dir, (IOFileFilter)new SuffixFileFilter(".avsc"), (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File schemaFile : schemaFiles) {
            schemaStrings.add(this.getSchemaStringFromFile(schemaFile));
        }
        return schemaStrings;
    }

    private List<String> getSchemaStringsFromJar(String jarPath, String directoryPath) {
        JarFile jar;
        LOG.info("Getting schema strings in: " + directoryPath + ", from jar: " + jarPath);
        try {
            jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatasetException((Throwable)e);
        }
        catch (IOException e) {
            throw new DatasetException((Throwable)e);
        }
        Enumeration<JarEntry> entries = jar.entries();
        ArrayList<String> schemaStrings = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            InputStream inputStream;
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().startsWith(directoryPath) || !jarEntry.getName().endsWith(".avsc")) continue;
            LOG.info("Found schema: " + jarEntry.getName());
            try {
                inputStream = jar.getInputStream(jarEntry);
            }
            catch (IOException e) {
                throw new DatasetException((Throwable)e);
            }
            String schemaString = AvroUtils.inputStreamToString(inputStream);
            schemaStrings.add(schemaString);
        }
        return schemaStrings;
    }
}

