/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;

public class Hadoop23Shims
extends HadoopShimsSecure {
    private static final String MR2_JOB_QUEUE_PROPERTY = "mapreduce.job.queuename";
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;

    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (this.isMR2((Configuration)conf)) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        String taskLogURL = null;
        try {
            Class<?> taskLogClass = Class.forName("TaskLogServlet");
            Method taskLogMethod = taskLogClass.getDeclaredMethod("getTaskLogUrl", String.class, String.class, String.class);
            URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
            taskLogURL = (String)taskLogMethod.invoke(null, taskTrackerHttpURL.getHost(), Integer.toString(taskTrackerHttpURL.getPort()), taskAttemptId);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Error trying to get task log URL", (Throwable)e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Error trying to get task log URL", (Throwable)e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Error trying to get task log URL", (Throwable)e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (SecurityException e) {
            LOG.error((Object)"Error trying to get task log URL", (Throwable)e);
            throw new MalformedURLException("Could not execute getTaskLogUrl: " + e.getCause());
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Error trying to get task log URL", (Throwable)e);
            throw new MalformedURLException("Method getTaskLogUrl not found: " + e.getCause());
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
        }
        return taskLogURL;
    }

    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContextImpl(conf, new org.apache.hadoop.mapreduce.TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    public org.apache.hadoop.mapreduce.TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new org.apache.hadoop.mapreduce.TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap ? TaskType.MAP : TaskType.REDUCE, taskId, id);
    }

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.task.JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    public boolean isLocalMode(Configuration conf) {
        if (this.isMR2(conf)) {
            return false;
        }
        return "local".equals(conf.get("mapreduce.framework.name")) || "local".equals(conf.get("mapred.job.tracker"));
    }

    public String getJobLauncherRpcAddress(Configuration conf) {
        if (this.isMR2(conf)) {
            return conf.get("yarn.resourcemanager.address");
        }
        return conf.get("mapred.job.tracker");
    }

    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            if (this.isMR2(conf)) {
                conf.set("mapreduce.framework.name", val);
                conf.set("mapreduce.jobtracker.address", val);
            } else {
                conf.set("mapred.job.tracker", val);
            }
        } else if (this.isMR2(conf)) {
            conf.set("yarn.resourcemanager.address", val);
        } else {
            conf.set("mapred.job.tracker", val);
        }
    }

    public String getKerberosShortName(String kerberosLongName) throws IOException {
        KerberosName kerberosName = new KerberosName(kerberosLongName);
        return kerberosName.getShortName();
    }

    public String getJobLauncherHttpAddress(Configuration conf) {
        if (this.isMR2(conf)) {
            return conf.get("yarn.resourcemanager.webapp.address");
        }
        return conf.get("mapred.job.tracker.http.address");
    }

    public String getMRFramework(Configuration conf) {
        return conf.get("mapreduce.framework.name");
    }

    public void setMRFramework(Configuration conf, String framework) {
        conf.set("mapreduce.framework.name", framework);
    }

    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        try {
            Class<?> clazz = Class.forName("org.apache.hadoop.mapred.lib.TotalOrderPartitioner");
            try {
                Method method = clazz.getMethod("setPartitionFile", Configuration.class, Path.class);
                method.invoke(null, jobConf, partitionFile);
            }
            catch (NoSuchMethodException nsme) {
                Method method = clazz.getMethod("setPartitionFile", JobConf.class, Path.class);
                method.invoke(null, jobConf, partitionFile);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find TotalOrderPartitioner.setPartitionFile", e);
        }
    }

    public void refreshDefaultQueue(Configuration conf, String userName) throws IOException {
        AllocationConfiguration allocConf;
        QueuePlacementPolicy queuePolicy;
        String requestedQueue = "default";
        if (this.isMR2(conf) && StringUtils.isNotBlank((String)userName) && this.isFairScheduler(conf) && (queuePolicy = (allocConf = new AllocationConfiguration(conf)).getPlacementPolicy()) != null && StringUtils.isNotBlank((String)(requestedQueue = queuePolicy.assignAppToQueue(requestedQueue, userName)))) {
            LOG.debug((Object)("Setting queue name to " + requestedQueue + " for user " + userName));
            conf.set(MR2_JOB_QUEUE_PROPERTY, requestedQueue);
        }
    }

    private boolean isFairScheduler(Configuration conf) {
        return FairScheduler.class.getName().equalsIgnoreCase(conf.get("yarn.resourcemanager.scheduler.class"));
    }

    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    private boolean isMR2(Configuration conf) {
        return "yarn".equalsIgnoreCase(conf.get("mapreduce.framework.name"));
    }

    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem23(fs, uri);
    }

    class ProxyFileSystem23
    extends ProxyFileSystem {
        public ProxyFileSystem23(FileSystem fs) {
            super(fs);
        }

        public ProxyFileSystem23(FileSystem fs, URI uri) {
            super(fs, uri);
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private RemoteIterator<LocatedFileStatus> stats;
                {
                    this.stats = ProxyFileSystem23.super.listLocatedStatus(ProxyFileSystem23.super.swizzleParamPath(f));
                }

                public boolean hasNext() throws IOException {
                    return this.stats.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    LocatedFileStatus result = (LocatedFileStatus)this.stats.next();
                    return new LocatedFileStatus(ProxyFileSystem23.super.swizzleFileStatus((FileStatus)result, false), result.getBlockLocations());
                }
            };
        }
    }

    private final class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims23() {
        }

        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID() {
            return new org.apache.hadoop.mapreduce.TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        public TaskAttemptContext createTaskAttemptContext(Configuration conf, org.apache.hadoop.mapreduce.TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, (Reporter)progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new org.apache.hadoop.mapreduce.task.JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            try {
                Constructor construct = JobContextImpl.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
                construct.setAccessible(true);
                return (JobContext)construct.newInstance(new JobConf((Configuration)conf), jobId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            boolean mr2 = Hadoop23Shims.this.isMR2(new Configuration());
            switch (name) {
                case CACHE_ARCHIVES: {
                    if (mr2) {
                        return "mapreduce.job.cache.archives";
                    }
                    return "mapred.cache.archives";
                }
                case CACHE_FILES: {
                    if (mr2) {
                        return "mapreduce.job.cache.files";
                    }
                    return "mapred.cache.files";
                }
                case CACHE_SYMLINK: {
                    if (mr2) {
                        return "mapreduce.job.cache.symlink.create";
                    }
                    return "mapred.create.symlink";
                }
            }
            return "";
        }

        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank((String)(address = StringUtils.substringAfterLast((String)address, (String)":")))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

