/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.RunJar;

public class JobLocalizer {
    static final Log LOG = LogFactory.getLog(JobLocalizer.class);
    private static final FsPermission urwx = FsPermission.createImmutable((short)448);
    private static final FsPermission urwx_gx = FsPermission.createImmutable((short)456);
    private static final FsPermission urw_gr = FsPermission.createImmutable((short)416);
    private final String user;
    private final String jobid;
    private final FileSystem lfs;
    private final List<Path> localDirs;
    private final LocalDirAllocator lDirAlloc;
    protected final JobConf ttConf;
    private final String JOBDIR;
    private final String DISTDIR;
    private final String WORKDIR;
    private final String JARDST;
    private final String JOBCONF;
    private final String JOBTOKEN;
    protected static final String JOB_LOCAL_CTXT = "mapred.job.local.dir";
    private static final FsPermission privateCachePerms = FsPermission.createImmutable((short)493);

    public JobLocalizer(JobConf ttConf, String user, String jobid) throws IOException {
        this(ttConf, user, jobid, ttConf.getTrimmedStrings("mapred.local.dir"));
    }

    public JobLocalizer(JobConf ttConf, String user, String jobid, String ... localDirs) throws IOException {
        if (null == user) {
            throw new IOException("Cannot initialize for null user");
        }
        this.user = user;
        if (null == jobid) {
            throw new IOException("Cannot initialize for null jobid");
        }
        this.jobid = jobid;
        this.ttConf = new JobConf(ttConf);
        this.lfs = FileSystem.getLocal((Configuration)this.ttConf).getRaw();
        this.localDirs = JobLocalizer.createPaths(user, localDirs);
        this.ttConf.setStrings(JOB_LOCAL_CTXT, localDirs);
        Collections.shuffle(this.localDirs);
        this.lDirAlloc = new LocalDirAllocator(JOB_LOCAL_CTXT);
        this.JOBDIR = "jobcache/" + jobid;
        this.DISTDIR = this.JOBDIR + "/" + "distcache";
        this.WORKDIR = this.JOBDIR + "/work";
        this.JARDST = this.JOBDIR + "/" + "jars" + "/job.jar";
        this.JOBCONF = this.JOBDIR + "/" + "job.xml";
        this.JOBTOKEN = this.JOBDIR + "/" + "jobToken";
    }

    private static List<Path> createPaths(String user, String[] str) throws IOException {
        if (null == str || 0 == str.length) {
            throw new IOException("mapred.local.dir contains no entries");
        }
        ArrayList<Path> ret = new ArrayList<Path>(str.length);
        for (int i = 0; i < str.length; ++i) {
            Path p = new Path(str[i], TaskTracker.getUserDir(user));
            ret.add(p);
            str[i] = p.toString();
        }
        return ret;
    }

    public void createLocalDirs() throws IOException {
        boolean userDirStatus = false;
        for (Path localDir : this.localDirs) {
            if (!this.lfs.mkdirs(localDir, urwx)) {
                LOG.warn((Object)("Unable to create the user directory : " + localDir));
                continue;
            }
            userDirStatus = true;
        }
        if (!userDirStatus) {
            throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + this.user);
        }
    }

    public void createUserDirs() throws IOException {
        LOG.info((Object)("Initializing user " + this.user + " on this TT."));
        boolean jobCacheDirStatus = false;
        boolean distributedCacheDirStatus = false;
        for (Path localDir : this.localDirs) {
            Path jobDir = new Path(localDir, "jobcache");
            if (!this.lfs.mkdirs(jobDir, urwx)) {
                LOG.warn((Object)("Unable to create job cache directory : " + jobDir));
            } else {
                jobCacheDirStatus = true;
            }
            Path distDir = new Path(localDir, "distcache");
            if (!this.lfs.mkdirs(distDir, urwx)) {
                LOG.warn((Object)("Unable to create distributed-cache directory : " + distDir));
                continue;
            }
            distributedCacheDirStatus = true;
        }
        if (!jobCacheDirStatus) {
            throw new IOException("Not able to initialize job-cache directories in any of the configured local directories for user " + this.user);
        }
        if (!distributedCacheDirStatus) {
            throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + this.user);
        }
    }

    public void createJobDirs() throws IOException {
        boolean initJobDirStatus = false;
        for (Path localDir : this.localDirs) {
            Path fullJobDir = new Path(localDir, this.JOBDIR);
            if (this.lfs.exists(fullJobDir)) {
                this.lfs.delete(fullJobDir, true);
            }
            if (!this.lfs.mkdirs(fullJobDir, urwx)) {
                LOG.warn((Object)("Not able to create job directory " + fullJobDir.toString()));
                continue;
            }
            initJobDirStatus = true;
        }
        if (!initJobDirStatus) {
            throw new IOException("Not able to initialize job directories in any of the configured local directories for job " + this.jobid.toString());
        }
    }

    public void initializeJobLogDir() throws IOException {
        Path jobUserLogDir = new Path(TaskLog.getJobDir(this.jobid).toURI().toString());
        if (!this.lfs.mkdirs(jobUserLogDir, urwx_gx)) {
            throw new IOException("Could not create job user log directory: " + jobUserLogDir);
        }
    }

    private void localizeJobJarFile(JobConf localJobConf) throws IOException {
        String jarFile = localJobConf.getJar();
        FileStatus status = null;
        long jarFileSize = -1L;
        if (jarFile != null) {
            Path jarFilePath = new Path(jarFile);
            FileSystem userFs = jarFilePath.getFileSystem((Configuration)localJobConf);
            try {
                status = userFs.getFileStatus(jarFilePath);
                jarFileSize = status.getLen();
            }
            catch (FileNotFoundException fe) {
                jarFileSize = -1L;
            }
            Path localJarFile = this.lDirAlloc.getLocalPathForWrite(this.JARDST, 5L * jarFileSize, (Configuration)this.ttConf);
            userFs.copyToLocalFile(jarFilePath, localJarFile);
            localJobConf.setJar(localJarFile.toString());
            RunJar.unJar((File)new File(localJarFile.toString()), (File)new File(localJarFile.getParent().toString()), (Pattern)localJobConf.getJarUnpackPattern());
            FileUtil.chmod((String)localJarFile.getParent().toString(), (String)"ugo+rx", (boolean)true);
        }
    }

    private static long[] downloadPrivateCacheObjects(Configuration conf, URI[] sources, Path[] dests, long[] times, boolean[] isPublic, boolean isArchive) throws IOException {
        if (null == sources && null == dests && null == times && null == isPublic) {
            return null;
        }
        if (sources.length != dests.length || sources.length != times.length || sources.length != isPublic.length) {
            throw new IOException("Distributed cache entry arrays have different lengths: " + sources.length + ", " + dests.length + ", " + times.length + ", " + isPublic.length);
        }
        long[] result = new long[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            if (isPublic[i]) continue;
            result[i] = TrackerDistributedCacheManager.downloadCacheObject(conf, sources[i], dests[i], times[i], isArchive, privateCachePerms);
        }
        return result;
    }

    public static long[] downloadPrivateCache(Configuration conf) throws IOException {
        long[] fileSizes = JobLocalizer.downloadPrivateCacheObjects(conf, DistributedCache.getCacheFiles(conf), DistributedCache.getLocalCacheFiles(conf), DistributedCache.getFileTimestamps(conf), TrackerDistributedCacheManager.getFileVisibilities(conf), false);
        long[] archiveSizes = JobLocalizer.downloadPrivateCacheObjects(conf, DistributedCache.getCacheArchives(conf), DistributedCache.getLocalCacheArchives(conf), DistributedCache.getArchiveTimestamps(conf), TrackerDistributedCacheManager.getArchiveVisibilities(conf), true);
        return ArrayUtils.addAll((long[])fileSizes, (long[])archiveSizes);
    }

    public void localizeJobFiles(JobID jobid, JobConf jConf, Path localJobTokenFile, TaskUmbilicalProtocol taskTracker) throws IOException, InterruptedException {
        this.localizeJobFiles(jobid, jConf, this.lDirAlloc.getLocalPathForWrite(this.JOBCONF, (Configuration)this.ttConf), localJobTokenFile, taskTracker);
    }

    public void localizeJobFiles(final JobID jobid, JobConf jConf, Path localJobFile, Path localJobTokenFile, final TaskUmbilicalProtocol taskTracker) throws IOException, InterruptedException {
        this.localizeJobJarFile(jConf);
        jConf.set(JOB_LOCAL_CTXT, this.ttConf.get(JOB_LOCAL_CTXT));
        jConf.set("mapreduce.job.jobTokenFile", localJobTokenFile.toString());
        jConf.set("mapred.local.dir", this.ttConf.get("mapred.local.dir"));
        TaskTracker.resetNumTasksPerJvm(jConf);
        final long[] sizes = JobLocalizer.downloadPrivateCache(jConf);
        if (sizes != null) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)jobid.toString());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    taskTracker.updatePrivateDistributedCacheSizes(jobid, sizes);
                    return null;
                }
            });
        }
        this.writeJobACLs(jConf, new Path(TaskLog.getJobDir(jobid).toURI().toString()));
        JobLocalizer.writeLocalJobFile(localJobFile, jConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJobACLs(JobConf conf, Path logDir) throws IOException {
        JobConf aclConf = new JobConf(false);
        String jobViewACL = conf.get("mapreduce.job.acl-view-job", " ");
        aclConf.set("mapreduce.job.acl-view-job", jobViewACL);
        String queue = conf.getQueueName();
        aclConf.setQueueName(queue);
        String qACLName = QueueManager.toFullPropertyName(queue, QueueManager.QueueACL.ADMINISTER_JOBS.getAclName());
        String queueAdminsACL = conf.get(qACLName, " ");
        aclConf.set(qACLName, queueAdminsACL);
        aclConf.set("user.name", this.user);
        FSDataOutputStream out = null;
        Path aclFile = new Path(logDir, TaskTracker.jobACLsFile);
        try {
            out = this.lfs.create(aclFile);
            aclConf.writeXml((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
        this.lfs.setPermission(aclFile, urw_gr);
    }

    public void createWorkDir(JobConf jConf) throws IOException {
        Path workDir = this.lDirAlloc.getLocalPathForWrite(this.WORKDIR, (Configuration)this.ttConf);
        if (!this.lfs.mkdirs(workDir)) {
            throw new IOException("Mkdirs failed to create " + workDir.toString());
        }
        jConf.set("job.local.dir", workDir.toUri().getPath());
    }

    public Path findCredentials() throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.JOBTOKEN, (Configuration)this.ttConf);
    }

    public int runSetup(String user, String jobid, Path localJobTokenFile, TaskUmbilicalProtocol taskTracker) throws IOException, InterruptedException {
        Path localJobFile = this.lDirAlloc.getLocalPathToRead(this.JOBCONF, (Configuration)this.ttConf);
        JobConf cfgJob = new JobConf(localJobFile);
        this.createWorkDir(cfgJob);
        this.localizeJobFiles(JobID.forName(jobid), cfgJob, localJobFile, localJobTokenFile, taskTracker);
        return 0;
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        final String user = argv[0];
        final String jobid = argv[1];
        final InetSocketAddress ttAddr = new InetSocketAddress(argv[2], Integer.parseInt(argv[3]));
        String uid = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!user.equals(uid)) {
            LOG.warn((Object)("Localization running as " + uid + " not " + user));
        }
        final JobConf conf = new JobConf();
        final JobLocalizer localizer = new JobLocalizer(conf, user, jobid);
        final Path jobTokenFile = localizer.findCredentials();
        Credentials creds = TokenCache.loadTokens(jobTokenFile.toUri().toString(), conf);
        LOG.debug((Object)("Loaded tokens from " + jobTokenFile));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        for (Token token : creds.getAllTokens()) {
            ugi.addToken(token);
        }
        UserGroupInformation ugiJob = UserGroupInformation.createRemoteUser((String)jobid);
        Token<JobTokenIdentifier> jt = TokenCache.getJobToken(creds);
        jt.setService(new Text(ttAddr.getAddress().getHostAddress() + ":" + ttAddr.getPort()));
        ugiJob.addToken(jt);
        final TaskUmbilicalProtocol taskTracker = (TaskUmbilicalProtocol)ugiJob.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TaskUmbilicalProtocol>(){

            @Override
            public TaskUmbilicalProtocol run() throws IOException {
                TaskUmbilicalProtocol taskTracker = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, (long)18L, (InetSocketAddress)ttAddr, (Configuration)conf);
                return taskTracker;
            }
        });
        System.exit((Integer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return localizer.runSetup(user, jobid, jobTokenFile, taskTracker);
                }
                catch (Throwable e) {
                    e.printStackTrace(System.out);
                    return -1;
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLocalJobFile(Path jobFile, JobConf conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(jobFile);
        FSDataOutputStream out = null;
        try {
            out = FileSystem.create((FileSystem)localFs, (Path)jobFile, (FsPermission)urw_gr);
            conf.writeXml((OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
    }
}

