/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

class JobQueueClient
extends Configured
implements Tool {
    JobClient jc;

    public JobQueueClient() {
    }

    public JobQueueClient(JobConf conf) throws IOException {
        this.setConf(conf);
    }

    private void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.jc = new JobClient(conf);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int run(String[] argv) throws Exception {
        int exitcode = -1;
        if (argv.length < 1) {
            this.displayUsage("");
            return exitcode;
        }
        String cmd = argv[0];
        boolean displayQueueList = false;
        boolean displayQueueInfoWithJobs = false;
        boolean displayQueueInfoWithoutJobs = false;
        boolean displayQueueAclsInfoForCurrentUser = false;
        if ("-list".equals(cmd)) {
            displayQueueList = true;
        } else if ("-showacls".equals(cmd)) {
            displayQueueAclsInfoForCurrentUser = true;
        } else {
            if (!"-info".equals(cmd)) {
                this.displayUsage(cmd);
                return exitcode;
            }
            if (argv.length == 2 && !argv[1].equals("-showJobs")) {
                displayQueueInfoWithoutJobs = true;
            } else {
                if (argv.length != 3) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                if (!argv[2].equals("-showJobs")) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                displayQueueInfoWithJobs = true;
            }
        }
        JobConf conf = new JobConf(this.getConf());
        this.init(conf);
        if (displayQueueList) {
            this.displayQueueList();
            return 0;
        }
        if (displayQueueInfoWithoutJobs) {
            this.displayQueueInfo(argv[1], false);
            return 0;
        }
        if (displayQueueInfoWithJobs) {
            this.displayQueueInfo(argv[1], true);
            return 0;
        }
        if (!displayQueueAclsInfoForCurrentUser) return exitcode;
        this.displayQueueAclsInfoForCurrentUser();
        return 0;
    }

    private void displayQueueInfo(String queue, boolean showJobs) throws IOException {
        JobQueueInfo jobQueueInfo = this.jc.getQueueInfo(queue);
        if (jobQueueInfo == null) {
            System.out.println("Queue Name : " + queue + " has no scheduling information");
        } else {
            this.printJobQueueInfo(jobQueueInfo);
        }
        if (showJobs) {
            System.out.printf("Job List\n", new Object[0]);
            JobStatus[] jobs = this.jc.getJobsFromQueue(queue);
            if (jobs == null) {
                jobs = new JobStatus[]{};
            }
            this.jc.displayJobList(jobs);
        }
    }

    private void printJobQueueInfo(JobQueueInfo jobQueueInfo) {
        System.out.println("Queue Name : " + jobQueueInfo.getQueueName());
        System.out.println("Queue State : " + jobQueueInfo.getQueueState());
        String schedInfo = jobQueueInfo.getSchedulingInfo();
        if (null == schedInfo || "".equals(schedInfo.trim())) {
            schedInfo = "N/A";
        }
        System.out.println("Scheduling Info : " + schedInfo);
    }

    private void displayQueueList() throws IOException {
        JobQueueInfo[] queues;
        for (JobQueueInfo queue : queues = this.jc.getQueues()) {
            this.printJobQueueInfo(queue);
        }
    }

    private void displayQueueAclsInfoForCurrentUser() throws IOException {
        QueueAclsInfo[] queueAclsInfoList = this.jc.getQueueAclsForCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (queueAclsInfoList.length > 0) {
            System.out.println("Queue acls for user :  " + ugi.getShortUserName());
            System.out.println("\nQueue  Operations");
            System.out.println("=====================");
            for (QueueAclsInfo queueInfo : queueAclsInfoList) {
                System.out.print(queueInfo.getQueueName() + "  ");
                String[] ops = queueInfo.getOperations();
                int max = ops.length - 1;
                for (int j = 0; j < ops.length; ++j) {
                    System.out.print(ops[j].replaceFirst("acl-", ""));
                    if (j >= max) continue;
                    System.out.print(",");
                }
                System.out.println();
            }
        } else {
            System.out.println("User " + ugi.getShortUserName() + " does not have access to any queue. \n");
        }
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobQueueClient ";
        if ("-queueinfo".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "<job-queue-name> [-showJobs]]");
        } else {
            System.err.printf(prefix + "<command> <args>\n", new Object[0]);
            System.err.printf("\t[-list]\n", new Object[0]);
            System.err.printf("\t[-info <job-queue-name> [-showJobs]]\n", new Object[0]);
            System.err.printf("\t[-showacls] \n\n", new Object[0]);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        }
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new JobQueueClient(), (String[])argv);
        System.exit(res);
    }
}

